/****************************************************************************\
*                                                                            *
*  SCALE.C                                                                   *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows 256-color bitmap      *
*  scaling and shearing functions.                                           *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  320
#define HEIGHT 200

// 40x20 256-color bitmapped image of a bird
char bird[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,10, 0,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,25,10,17,10,17,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,10,25,25,10,17,10,17,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   10,25,25,25,25,10,25,10,25,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,
   10,25,25,25,25,10,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,10,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,25,
   10,25,25,25,25,25,25,25,25,10, 0, 0,10,10,10,10,10,17,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,
   25,25,25,25,25,25,25,25,10, 0, 0,10,25,25,25,25,25,10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,
   10,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,25,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,10,
   25,25,25,25,25,25,25,25,10,10,25,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,10,25,25,25,25,25,10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,25,25,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,10,10,10, 0, 0, 0, 0, 0,10,25,25,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0,
   10,17,17,17,17,10,10,10,10, 0,10,10,25,25,25,25,25,25,25,25,
   25,25,25,25,25,10,25,25,25,10,10,10,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,17,17,17,17,17,17,17,10,25,25,10,25,25,25,25,25,25,25,
   25,25,25,25,10,25,25,25,10,17,17,17,17,10,10,10,10,10,10, 0,
    0, 0,10,10,10,10,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,25,25,10,14,14,10, 0, 0,
    0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,14,25,25,10,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,25,25,
   25,25,25,25,25,25,25,10,10,10,10,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,
   10,10,10,10,10,10,10, 0, 0, 0, 0,10,10,10, 0, 0, 0, 0, 0, 0
};

// scaled/sheared bird bitmap (80x40 max)
char bird_scaled[80*40];

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGscale";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName, // window class name
      "Bitmap Scaling and Shearing",// window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      CW_USEDEFAULT,           // initial x size
      CW_USEDEFAULT,           // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
int      hvb;
UINT     cxClient, cyClient;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_setcolor(20);
         fg_fillpage();

         // draw 40x20 bird (original bitmap)
         fg_move(6,80);
         fg_drwimage(bird,40,20);

         // draw 50x25 bird
         fg_move(48,80);
         fg_scale(bird,bird_scaled,40,20,50,25);
         fg_drwimage(bird_scaled,50,25);

         // draw 60x30 bird
         fg_move(100,80);
         fg_scale(bird,bird_scaled,40,20,60,30);
         fg_drwimage(bird_scaled,60,30);

         // draw 70x35 bird
         fg_move(162,80);
         fg_scale(bird,bird_scaled,40,20,70,35);
         fg_drwimage(bird_scaled,70,35);

         // draw 80x40 bird
         fg_move(234,80);
         fg_scale(bird,bird_scaled,40,20,80,40);
         fg_drwimage(bird_scaled,80,40);

         // draw 50x20 bird sheared left horizontally
         fg_move(55,160);
         fg_shear(bird,bird_scaled,40,20,50,0);
         fg_drwimage(bird_scaled,50,20);

         // draw 50x20 bird sheared right horizontally
         fg_move(115,160);
         fg_shear(bird,bird_scaled,40,20,50,1);
         fg_drwimage(bird_scaled,50,20);

         // draw 40x30 bird sheared left vertically
         fg_move(175,160);
         fg_shear(bird,bird_scaled,40,20,30,2);
         fg_drwimage(bird_scaled,40,30);

         // draw 40x30 bird sheared left vertically
         fg_move(225,160);
         fg_shear(bird,bird_scaled,40,20,30,3);
         fg_drwimage(bird_scaled,40,30);

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
