/****************************************************************************\
*                                                                            *
*  SCROLLER.C                                                                *
*                                                                            *
*  This program demonstrates circular scrolling within a virtual buffer.     *
*                                                                            *
*  Because fg_scroll() requires a "hidden" virtual buffer to save and then   *
*  restore portions of the area being scrolled, we create a second virtual   *
*  buffer for this purpose.                                                  *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  320
#define HEIGHT 200

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);
void scroll(void);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGscroller";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName,      // window class name
      "Scrolling Demo",        // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      WIDTH,                   // initial x size
      HEIGHT,                  // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   // The message loop processes entries placed in the message queue.
   // When no message is ready, call scroll() to perform one frame of
   // animation.

   while (TRUE)
   {
      if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
      {
         if (msg.message == WM_QUIT)
            break;
         else
         {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
         }
      }
      else
         scroll();
   }

   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb1, hvb2;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb1 = fg_vballoc(WIDTH,HEIGHT);
         hvb2 = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb2);
         fg_vbcolors();
         fg_vbopen(hvb1);
         fg_vbcolors();
         fg_sethpage(hvb2);

         fg_setcolor(19);
         fg_fillpage();
         fg_setcolor(25);
         fg_rect(132,188,50,150);

         fg_setcolor(20);
         fg_move(160,67);
         fg_draw(175,107);
         fg_draw(140,82);
         fg_draw(180,82);
         fg_draw(145,107);
         fg_draw(160,67);
         fg_paint(160,77);
         fg_paint(150,87);
         fg_paint(160,87);
         fg_paint(170,87);
         fg_paint(155,97);
         fg_paint(165,97);
         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb1);
         fg_vbfree(hvb2);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}

/****************************************************************************\
*                                                                            *
*  The scroll() function moves the scrolling region up four pixels in a      *
*  circular manner. It is called from the message loop in WinMain when no    *
*  messages are waiting.                                                     *
*                                                                            *
\****************************************************************************/

void scroll()
{
   fg_scroll(136,184,50,150,-4,0);
   fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
}
