/****************************************************************************\
*                                                                            *
*  STRINGS2.C                                                                *
*                                                                            *
*  This program shows how to display strings in the virtual buffer. Because  *
*  WinG is needed to do this, you must link this program with the Fastgraph  *
*  for Windows WinG support library, and WinG must be available on your      *
*  system.                                                                   *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  320
#define HEIGHT 200

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGstrings2";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName, // window class name
      "Display Strings in Virtual Buffer", // window caption
      WS_OVERLAPPEDWINDOW,          // window style
      CW_USEDEFAULT,                // initial x position
      CW_USEDEFAULT,                // initial y position
      WIDTH,                        // initial x size
      HEIGHT,                       // initial y size
      NULL,                         // parent window handle
      NULL,                         // window menu handle
      hInstance,                    // program instance handle
      NULL);                        // creation parameters

   if (fg_getdc() == 0)
   {
      MessageBox(window,"WinG not available!","STRINGS2",MB_ICONSTOP|MB_OK);
      return 0;
   }

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_setcolor(24);
         fg_fillpage();

         fg_setcolor(19);
         fg_fontdc(fg_getdc());

         // upper vertical justification
         fg_move(0,0);
         fg_justify(-1,1);
         fg_print("FG/Windows",10);
         fg_move(WIDTH/2,0);
         fg_justify(0,1);
         fg_print("FG/Windows",10);
         fg_move(WIDTH-1,0);
         fg_justify(1,1);
         fg_print("FG/Windows",10);

         // centered vertical justification
         fg_move(0,HEIGHT/2);
         fg_justify(-1,0);
         fg_print("FG/Windows",10);
         fg_move(WIDTH/2,HEIGHT/2);
         fg_justify(0,0);
         fg_print("FG/Windows",10);
         fg_move(WIDTH-1,HEIGHT/2);
         fg_justify(1,0);
         fg_print("FG/Windows",10);

         // lower vertical justification
         fg_move(0,HEIGHT-1);
         fg_justify(-1,-1);
         fg_print("FG/Windows",10);
         fg_move(WIDTH/2,HEIGHT-1);
         fg_justify(0,-1);
         fg_print("FG/Windows",10);
         fg_move(WIDTH-1,HEIGHT-1);
         fg_justify(1,-1);
         fg_print("FG/Windows",10);

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
