/****************************************************************************\
*                                                                            *
*  SWCHARS.C                                                                 *
*                                                                            *
*  This program displays all characters in the Fastgraph for Windows primary *
*  and alternate software fonts.                                             *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  640
#define HEIGHT 480

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGswchars";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName, // window class name
      "Software Character Set",     // window caption
      WS_OVERLAPPEDWINDOW,          // window style
      CW_USEDEFAULT,                // initial x position
      CW_USEDEFAULT,                // initial y position
      WIDTH,                        // initial x size
      HEIGHT,                       // initial y size
      NULL,                         // parent window handle
      NULL,                         // window menu handle
      hInstance,                    // program instance handle
      NULL);                        // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
int      xdest, ydest;
int      hvb;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_initw();
         fg_setworld(0.0,6.39,0.0,4.79);
         fg_setsizew(0.2);

         fg_setcolor(25);
         fg_fillpage();
         fg_setcolor(19);
         fg_movew(3.2,4.2);
         fg_swchar("Software characters - font 1",28,0);
         fg_setcolor(10);
         fg_movew(0.5,3.9);
         fg_swchar("ABCDEFGHIJKLMNOPQRSTUVWXYZ",26,-1);
         fg_movew(0.5,3.6);
         fg_swchar("abcdefghijklmnopqrstuvwxyz",26,-1);
         fg_movew(0.5,3.3);
         fg_swchar("0123456789",10,-1);
         fg_movew(0.5,3.0);
         fg_swchar("!\"#$%&'()*+,-./:;<=>?[]^`{|}~",29,-1);

         fg_setcolor(19);
         fg_movew(3.2,2.5);
         fg_swchar("Software characters - font 2",28,0);
         fg_setcolor(10);
         fg_movew(0.5,2.2);
         fg_swchar("\\ABCDEFGHIJKLMNOPRSTUWXYZ",25,-1);
         fg_movew(0.5,1.9);
         fg_swchar("\\abcdefghijklmnoprstuwxyz",25,-1);
         fg_movew(0.5,1.3);
         fg_swchar("\\012345678#$%&()*+/<=>?[]{}",27,-1);

         fg_setratio(1.2);
         fg_movew(0.5,0.6);
         fg_swchar("cos\\^2\\h\\+sin\\^2\\h\\=1",21,-1);

         fg_movew(5.9,0.6);
         fg_swchar("H\\v2O U\\v2\\v3\\v2",16,1);

         fg_setratio(1.0);
         fg_movew(3.2,0.2);
         fg_swchar("One _word_ is underlined.",25,0);

         fg_setcolor(19);
         fg_movew(0.0,2.8);
         fg_draww(6.39,2.8);
         fg_movew(0.0,0.9);
         fg_draww(6.39,0.9);

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,xdest,ydest);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         xdest = ((int)LOWORD(lParam) - WIDTH) / 2;
         ydest = ((int)HIWORD(lParam) - HEIGHT) / 2;
         if (xdest < 0) xdest = 0;
         if (ydest < 0) ydest = 0;
         ydest = ((int)HIWORD(lParam)-1) - ydest;
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
