{*****************************************************************************
*                                                                            *
*  BITMAP.PAS                                                                *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows 256-color bitmap      *
*  display functions.                                                        *
*                                                                            *
*****************************************************************************}

program bitmap;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGbitmap';
  WIDTH   = 320;
  HEIGHT  = 200;

  IDM_DRWIMAGE = 1;
  IDM_CLPIMAGE = 2;
  IDM_REVIMAGE = 3;
  IDM_FLPIMAGE = 4;
  IDM_PUTIMAGE = 5;
  IDM_QUIT     = 6;

  { 40x20 256-color bitmapped image of a bird }
  bird : array [1..800] of byte = (
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,10, 0,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,25,10,17,10,17,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,10,25,25,10,17,10,17,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   10,25,25,25,25,10,25,10,25,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,
   10,25,25,25,25,10,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,10,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,25,
   10,25,25,25,25,25,25,25,25,10, 0, 0,10,10,10,10,10,17,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,
   25,25,25,25,25,25,25,25,10, 0, 0,10,25,25,25,25,25,10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,
   10,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,25,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,10,
   25,25,25,25,25,25,25,25,10,10,25,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,10,25,25,25,25,25,10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,25,25,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,10,10,10, 0, 0, 0, 0, 0,10,25,25,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0,
   10,17,17,17,17,10,10,10,10, 0,10,10,25,25,25,25,25,25,25,25,
   25,25,25,25,25,10,25,25,25,10,10,10,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,17,17,17,17,17,17,17,10,25,25,10,25,25,25,25,25,25,25,
   25,25,25,25,10,25,25,25,10,17,17,17,17,10,10,10,10,10,10, 0,
    0, 0,10,10,10,10,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,25,25,10,14,14,10, 0, 0,
    0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,14,25,25,10,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,25,25,
   25,25,25,25,25,25,25,10,10,10,10,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,
   10,10,10,10,10,10,10, 0, 0, 0, 0,10,10,10, 0, 0, 0, 0, 0, 0);

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(20);
      fg_fillpage;
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_DRWIMAGE:
        begin
          fg_fillpage;
          fg_move(WIDTH div 2 - 20,HEIGHT div 2 + 10);
          fg_drwimage(bird,40,20);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_CLPIMAGE:
        begin
          fg_fillpage;
          fg_move(-20,HEIGHT div 2 + 10);
          fg_clpimage(bird,40,20);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_REVIMAGE:
        begin
          fg_fillpage;
          fg_move(WIDTH div 2 - 20,HEIGHT div 2 + 10);
          fg_revimage(bird,40,20);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_FLPIMAGE:
        begin
          fg_fillpage;
          fg_move(WIDTH-20,HEIGHT div 2 + 10);
          fg_flpimage(bird,40,20);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_PUTIMAGE:
        begin
          fg_fillpage;
          fg_move(WIDTH div 2 - 20,HEIGHT div 2 + 10);
          fg_putimage(bird,40,20);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    '256-Color Bitmap Demo',    { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
