{*****************************************************************************
*                                                                            *
*  BITMAP16.PAS                                                              *
*                                                                            *
*  This program demonstrates how to translate a 16-color bitmap to the 256-  *
*  color format, and display the resulting 256-color image.                  *
*                                                                            *
*****************************************************************************}

program bitmap16;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGbitmap16';
  WIDTH   = 320;
  HEIGHT  = 200;

  { 40x20 pixel (20x20 byte) 16-color bitmapped image of a bird }

  bird16 : array [1..20*20] of byte = (
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$11,$01,$01,$00,$00,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$1F,$17,$17,$11,$00,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $01,$FF,$17,$17,$1F,$10,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $1F,$FF,$F1,$F1,$FF,$10,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$01,$11,
    $1F,$FF,$F1,$F1,$F1,$00,$00,$00,$01,$10,
    $00,$00,$00,$00,$00,$00,$00,$00,$1F,$FF,
    $1F,$FF,$FF,$FF,$F1,$00,$11,$11,$17,$10,
    $00,$00,$00,$00,$00,$00,$00,$01,$1F,$F1,
    $FF,$FF,$FF,$FF,$10,$01,$FF,$FF,$F1,$00,
    $00,$00,$00,$00,$00,$00,$00,$1F,$F1,$FF,
    $1F,$FF,$FF,$FF,$10,$1F,$FF,$FF,$10,$00,
    $00,$00,$00,$00,$00,$00,$01,$F1,$FF,$1F,
    $FF,$FF,$FF,$FF,$10,$1F,$FF,$F1,$00,$00,
    $00,$00,$00,$00,$00,$00,$01,$FF,$1F,$F1,
    $FF,$FF,$FF,$FF,$11,$FF,$FF,$10,$00,$00,
    $00,$00,$00,$00,$00,$00,$01,$F1,$FF,$1F,
    $FF,$FF,$FF,$F1,$FF,$FF,$F1,$00,$00,$00,
    $00,$00,$00,$00,$00,$01,$1F,$F1,$FF,$FF,
    $FF,$FF,$FF,$F1,$FF,$1F,$10,$00,$00,$00,
    $00,$00,$00,$00,$00,$1F,$1F,$FF,$FF,$FF,
    $FF,$FF,$FF,$F1,$FF,$FF,$10,$00,$00,$00,
    $01,$11,$10,$00,$00,$1F,$F1,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$F1,$F1,$00,$00,$00,$00,
    $17,$77,$71,$11,$10,$11,$FF,$FF,$FF,$FF,
    $FF,$FF,$F1,$FF,$F1,$11,$10,$00,$00,$00,
    $01,$77,$77,$77,$71,$FF,$1F,$FF,$FF,$FF,
    $FF,$FF,$1F,$FF,$17,$77,$71,$11,$11,$10,
    $00,$11,$11,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$FF,$FF,$FF,$14,$41,$00,
    $00,$00,$00,$11,$11,$11,$11,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$FF,$FF,$4F,$F1,$10,$00,
    $00,$00,$00,$00,$00,$00,$00,$11,$FF,$FF,
    $FF,$FF,$FF,$F1,$11,$1F,$FF,$10,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$11,$11,
    $11,$11,$11,$10,$00,$01,$11,$00,$00,$00);

  translation : array [0..15] of byte =
                  (0,10,12,13,14,15,16,17,18,19,20,21,22,23,24,25);

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  bird256 : array [1..40*20] of byte;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;
  i : integer;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_unpack(bird16,bird256,20*20);
      for i := 1 to 40*20 do
        bird256[i] := translation[bird256[i]];
         
      fg_setcolor(20);
      fg_fillpage;
      fg_move(WIDTH div 2 - 20,HEIGHT div 2 + 10);
      fg_drwimage(bird256,40,20);
      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    '16-Color Bitmap Demo',     { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
