{*****************************************************************************
*                                                                            *
*  FONTDEMO.PAS                                                              *
*                                                                            *
*  This program shows how use Windows stock fonts in Fastgraph for Windows,  *
*  and also how to create and use a Windows logical font. The logical font   *
*  is a 24x12 script font.                                                   *
*                                                                            *
*****************************************************************************}

program fontdemo;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGfontdemo';
  WIDTH   = 320;
  HEIGHT  = 200;

var
  cxClient, cyClient : word;
  dc   : hDC;
  font : hFont;
  hpal : hPalette;
  hvb  : integer;
  lf   : tLogfont;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;
  x : integer;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(24);
      fg_fillpage;

      font := CreateFontIndirect(lf);
      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
      fg_setcolor(19);
      x := fg_xclient(20);

      fg_move(x,fg_yclient(20));
      fg_fontload(10);
      fg_print('OEM fixed font',14);

      fg_move(x,fg_yclient(40));
      fg_fontload(11);
      fg_print('ANSI fixed font',15);

      fg_move(x,fg_yclient(60));
      fg_fontload(12);
      fg_print('ANSI var font',13);

      fg_move(x,fg_yclient(80));
      fg_fontload(13);
      fg_print('system font',11);

      fg_move(x,fg_yclient(100));
      fg_fontload(14);
      fg_print('device default font',19);

      fg_move(x,fg_yclient(120));
      fg_fontload(16);
      fg_print('system fixed font',17);

      fg_move(x,fg_yclient(160));
      fg_logfont(font);
      fg_print('script font',11);

      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(font);
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  lf.lfHeight := 24;                { character height in pixels }
  lf.lfWidth := 12;                 { character width in pixels }
  lf.lfEscapement := 0;             { orientation of next character }
  lf.lfOrientation := 0;            { orientation of first character }
  lf.lfWeight := FW_NORMAL;         { normal thickness }
  lf.lfItalic := 0;                 { not italic characters }
  lf.lfUnderline := 0;              { not underlined characters }
  lf.lfStrikeOut := 0;              { not strikeout characters }
  lf.lfCharSet := OEM_CHARSET;      { OEM character set }
  lf.lfOutPrecision := 0;           { default output precision }
  lf.lfClipPrecision := 0;          { default clipping precision }
  lf.lfQuality := DEFAULT_QUALITY;  { default scaling quality }
  lf.lfPitchAndFamily := FF_SCRIPT; { default pitch, script font family }
  lstrcpy(lf.lfFaceName,'script'+chr(0)); { script typeface }

  window := CreateWindow(
    AppName,                    { window class name }
    'Fastgraph for Windows Font Demo', { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    WIDTH,                      { initial x size }
    HEIGHT,                     { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
