{*****************************************************************************
*                                                                            *
*  KBDEMO.PAS                                                                *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window using the low-level keyboard handler.                    *
*                                                                            *
*****************************************************************************}

program kbdemo;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGkbdemo';
  WIDTH   = 640;
  HEIGHT  = 480;

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  x, y : integer;
  xlimit, ylimit : integer;
  CanGoLeft, CanGoRight, CanGoUp, CanGoDown : boolean;

{*****************************************************************************
*                                                                            *
*  The check_for_panning() function checks if any of the four arrow keys are *
*  pressed, and if so, pans in that direction if possible. It is called from *
*  the message loop in WinMain when no messages are waiting.                 *
*                                                                            *
*****************************************************************************}

procedure check_for_panning;

const
  KB_ESCAPE =  1;
  KB_LEFT   = 75;
  KB_RIGHT  = 77;
  KB_UP     = 72;
  KB_DOWN   = 80;

begin
  if (fg_kbtest(KB_LEFT) = 1) and CanGoLeft then
  begin
    if (x = 0) then CanGoRight := TRUE;
    inc(x);
    fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
    if (x = xlimit) then CanGoLeft := FALSE;
  end

  else if (fg_kbtest(KB_RIGHT) = 1) and CanGoRight then
  begin
    if (x = xlimit) then CanGoLeft := TRUE;
    dec(x);
    fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
    if (x = 0) then CanGoRight := FALSE;
  end

  else if (fg_kbtest(KB_UP) = 1) and CanGoUp then
  begin
    if (y = 0) then CanGoDown := TRUE;
    inc(y);
    fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
    if (y = ylimit) then CanGoUp := FALSE;
  end

  else if (fg_kbtest(KB_DOWN) = 1) and CanGoDown then
  begin
    if (y = ylimit) then CanGoUp := TRUE;
    dec(y);
    fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
    if (y = 0) then CanGoDown := FALSE;
  end

  else if (fg_kbtest(KB_ESCAPE) = 1) then
  begin
    x := 0;
    y := 0;
    fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,0,HEIGHT-1);
    if (xlimit > 0) then CanGoLeft := TRUE;
    if (ylimit > 0) then CanGoUp := TRUE;
    CanGoRight := FALSE;
    CanGoDown  := FALSE;
  end;
end;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_showbmp('PORCH.BMP'+chr(0),0);
      x := 0;
      y := 0;
      CanGoLeft  := TRUE;
      CanGoUp    := TRUE;
      CanGoRight := FALSE;
      CanGoDown  := FALSE;

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);

      if (cxClient < WIDTH) then
      begin
        xlimit := WIDTH - cxClient;
        if (x < xlimit) then CanGoLeft := TRUE;
        if (x > 0)      then CanGoRight := TRUE;
      end
      else
      begin
        xlimit := 0;
        CanGoLeft  := FALSE;
        CanGoRight := FALSE;
      end;

      if (cyClient < HEIGHT) then
      begin
        ylimit := HEIGHT - cyClient;
        if (y < ylimit) then CanGoUp := TRUE;
        if (y > 0)      then CanGoDown := TRUE;
      end
      else
      begin
        ylimit := 0;
        CanGoUp   := FALSE;
        CanGoDown := FALSE;
      end;

      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Keyboard Handler Demo',    { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    WIDTH div 2,                { initial x size }
    HEIGHT div 2,               { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  { The message loop processes entries placed in the message queue. }
  { When no message is ready, call check_for_panning() to check if  }
  { we want to perform panning.                                     }

  while (TRUE) do
  begin
    if PeekMessage(message,0,0,0,PM_REMOVE) then
    begin
      if message.message = WM_QUIT then
        Exit
      else
      begin
        TranslateMessage(message);
        DispatchMessage(message);
      end;
    end
    else
      check_for_panning;
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
