{*****************************************************************************
*                                                                            *
*  MCDEMO.PAS                                                                *
*                                                                            *
*  This program shows how to change the shape of the mouse cursor.           *
*                                                                            *
*****************************************************************************}

program mcdemo;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGmcdemo';
  WIDTH   = 320;
  HEIGHT  = 200;

  cross : array [1..32] of word = (
              $E03F,$E03F,$E03F,$0007,$0007,$0007,$0007,$0007,
              $0007,$0007,$E03F,$E03F,$E03F,$FFFF,$FFFF,$FFFF,
              $0000,$0F80,$0F80,$0F80,$7FF0,$7FF0,$7FF0,$7FF0,
              $7FF0,$0F80,$0F80,$0F80,$0000,$0000,$0000,$0000);
var
  cxClient, cyClient : word;
  cursor : hCursor;
  dc     : hDC;
  hpal   : hPalette;
  hvb    : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(20);
      fg_fillpage;

      fg_mouseini;
      cursor := fg_mouseptr(cross,6,6);

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETCURSOR:
    begin
      if (LOWORD(lParam) = HTCLIENT) then
      begin
        fg_mousecur(cursor);
        Exit;
      end;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DestroyCursor(cursor);
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Mouse Cursor Demo',        { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
