{*****************************************************************************
*                                                                            *
*  MONOMAP.PAS                                                               *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows monochrome bitmap     *
*  display functions.                                                        *
*                                                                            *
*****************************************************************************}

program monomap;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGmonomap';
  WIDTH   = 320;
  HEIGHT  = 200;

  IDM_DRAWMAP = 1;
  IDM_CLIPMAP = 2;
  IDM_QUIT    = 3;

  hello : array [1..40] of byte = (
    $00,$00,$00,$00,$00,
    $CC,$78,$78,$78,$78,
    $CC,$C0,$30,$30,$CC,
    $CC,$FC,$30,$30,$CC,
    $FC,$CC,$30,$30,$CC,
    $CC,$78,$30,$30,$78,
    $CC,$00,$30,$30,$00,
    $CC,$00,$70,$70,$00);

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(25);
      fg_fillpage;
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_DRAWMAP:
        begin
          fg_setcolor(25);
          fg_fillpage;
          fg_setcolor(10);
          fg_move(WIDTH div 2 - 20,HEIGHT div 2 + 4);
          fg_drawmap(hello,5,8);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_CLIPMAP:
        begin
          fg_setcolor(25);
          fg_fillpage;
          fg_setcolor(22);
          fg_move(-12,HEIGHT div 2 + 4);
          fg_clipmap(hello,5,8);
          fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Monochrome Bitmap Demo',   { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
