{*****************************************************************************
*                                                                            *
*  PANNER.PAS                                                                *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window.                                                         *
*                                                                            *
*****************************************************************************}

program panner;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGpanner';
  WIDTH   = 640;
  HEIGHT  = 480;

  IDM_LEFT  = 1;
  IDM_RIGHT = 2;
  IDM_UP    = 3;
  IDM_DOWN  = 4;
  IDM_RESET = 5;
  IDM_QUIT  = 6;

var
  cxClient, cyClient : word;
  dc   : hDC;
  menu : hMenu;
  hpal : hPalette;
  hvb  : integer;
  x, y : integer;
  xlimit, ylimit : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_showbmp('PORCH.BMP'+chr(0),0);
      x := 0;
      y := 0;

      menu := GetMenu(window);
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_LEFT:
        begin
          if (x = 0) then
          begin
            EnableMenuItem(menu,IDM_RIGHT,MF_ENABLED);
            DrawMenuBar(window);
          end;
          inc(x);
          fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
          if (x = xlimit) then
          begin
            EnableMenuItem(menu,IDM_LEFT,MF_GRAYED);
            DrawMenuBar(window);
          end;
          Exit;
        end;

        IDM_RIGHT:
        begin
          if (x = xlimit) then
          begin
            EnableMenuItem(menu,IDM_LEFT,MF_ENABLED);
            DrawMenuBar(window);
          end;
          dec(x);
          fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
          if (x = 0) then
          begin
            EnableMenuItem(menu,IDM_RIGHT,MF_GRAYED);
            DrawMenuBar(window);
          end;
          Exit;
        end;

        IDM_UP:
        begin
          if (y = 0) then
          begin
            EnableMenuItem(menu,IDM_DOWN,MF_ENABLED);
            DrawMenuBar(window);
          end;
          inc(y);
          fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
          if (y = ylimit) then
          begin
            EnableMenuItem(menu,IDM_UP,MF_GRAYED);
            DrawMenuBar(window);
          end;
          Exit;
        end;

        IDM_DOWN:
        begin
          if (y = ylimit) then
          begin
            EnableMenuItem(menu,IDM_UP,MF_ENABLED);
            DrawMenuBar(window);
          end;
          dec(y);
          fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
          if (y = 0) then
          begin
            EnableMenuItem(menu,IDM_DOWN,MF_GRAYED);
            DrawMenuBar(window);
          end;
          Exit;
        end;

        IDM_RESET:
        begin
          x := 0;
          y := 0;
          fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,0,HEIGHT-1);
          if (xlimit > 0) then EnableMenuItem(menu,IDM_LEFT,MF_ENABLED);
          if (ylimit > 0) then EnableMenuItem(menu,IDM_UP,MF_ENABLED);
          EnableMenuItem(menu,IDM_RIGHT,MF_GRAYED);
          EnableMenuItem(menu,IDM_DOWN,MF_GRAYED);
          DrawMenuBar(window);
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);

      if (cxClient < WIDTH) then
      begin
        xlimit := WIDTH - cxClient;
        if (x < xlimit) then EnableMenuItem(menu,IDM_LEFT,MF_ENABLED);
        if (x > 0)      then EnableMenuItem(menu,IDM_RIGHT,MF_ENABLED);
      end
      else
      begin
        xlimit := 0;
        EnableMenuItem(menu,IDM_LEFT,MF_GRAYED);
        EnableMenuItem(menu,IDM_RIGHT,MF_GRAYED);
      end;

      if (cyClient < HEIGHT) then
      begin
        ylimit := HEIGHT - cyClient;
        if (y < ylimit) then EnableMenuItem(menu,IDM_UP,MF_ENABLED);
        if (y > 0)      then EnableMenuItem(menu,IDM_DOWN,MF_ENABLED);
      end
      else
      begin
        ylimit := 0;
        EnableMenuItem(menu,IDM_UP,MF_GRAYED);
        EnableMenuItem(menu,IDM_DOWN,MF_GRAYED);
      end;

      DrawMenuBar(window);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Panning Demo',             { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    WIDTH div 2,                { initial x size }
    HEIGHT div 2,               { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
