{*****************************************************************************
*                                                                            *
*  PRDEMO.PAS                                                                *
*                                                                            *
*  This program shows how to print the contents of a virtual buffer.  It     *
*  first loads a 640x480 BMP file into a virtual buffer and displays it.     *
*  When the user clicks the Print selection on the top-level menu, a 6-inch  *
*  by 4-inch copy of the BMP image is sent to the default printer.           *
*                                                                            *
*****************************************************************************}

program prdemo;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGprdemo';
  WIDTH   = 640;
  HEIGHT  = 480;

  IDM_PRINT = 1;
  IDM_QUIT  = 2;

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_showbmp('PORCH.BMP'+chr(0),0);
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_PRINT:
        begin
          if (fg_printer(10) = 0) then
          begin
            fg_vbprint(0,WIDTH-1,0,HEIGHT-1,0,600,0,400,2);
            fg_printer(1);
            fg_printer(11);
          end
          else
            MessageBox(window,'Printer setup failed','PRDEMO',MB_ICONSTOP OR MB_OK);
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;
         
    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Printing Demo',            { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
