{*****************************************************************************
*                                                                            *
*  SCALE.PAS                                                                 *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows 256-color bitmap      *
*  scaling and shearing functions.                                           *
*                                                                            *
*****************************************************************************}

program scale;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGscale';
  WIDTH   = 320;
  HEIGHT  = 200;

  { 40x20 256-color bitmapped image of a bird }
  bird : array [1..40*20] of byte = (
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0,10,10, 0,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0,10,25,10,17,10,17,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0,10,25,25,10,17,10,17,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    10,25,25,25,25,10,25,10,25,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,
    10,25,25,25,25,10,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,10,10, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,25,
    10,25,25,25,25,25,25,25,25,10, 0, 0,10,10,10,10,10,17,10, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,
    25,25,25,25,25,25,25,25,10, 0, 0,10,25,25,25,25,25,10, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,
    10,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,25,10, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
    25,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,10, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,10,
    25,25,25,25,25,25,25,25,10,10,25,25,25,25,10, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
    25,25,25,25,25,25,25,10,25,25,25,25,25,10, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,25,25,25,25,
    25,25,25,25,25,25,25,10,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,25,25,25,25,25,
    25,25,25,25,25,25,25,10,25,25,25,25,10, 0, 0, 0, 0, 0, 0, 0,
     0,10,10,10,10, 0, 0, 0, 0, 0,10,25,25,10,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0,
    10,17,17,17,17,10,10,10,10, 0,10,10,25,25,25,25,25,25,25,25,
    25,25,25,25,25,10,25,25,25,10,10,10,10, 0, 0, 0, 0, 0, 0, 0,
     0,10,17,17,17,17,17,17,17,10,25,25,10,25,25,25,25,25,25,25,
    25,25,25,25,10,25,25,25,10,17,17,17,17,10,10,10,10,10,10, 0,
     0, 0,10,10,10,10,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,25,25,25,25,25,10,14,14,10, 0, 0,
     0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,25,25,25,14,25,25,10,10, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,25,25,
    25,25,25,25,25,25,25,10,10,10,10,25,25,25,10, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,
    10,10,10,10,10,10,10, 0, 0, 0, 0,10,10,10, 0, 0, 0, 0, 0, 0);

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

  { scaled/sheared bird bitmap (80x40 max) }
  bird_scaled : array [1..80*40] of byte;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(20);
      fg_fillpage;

      { draw 40x20 bird (original bitmap) }
      fg_move(6,80);
      fg_drwimage(bird,40,20);

      { draw 50x25 bird }
      fg_move(48,80);
      fg_scale(bird,bird_scaled,40,20,50,25);
      fg_drwimage(bird_scaled,50,25);

      { draw 60x30 bird }
      fg_move(100,80);
      fg_scale(bird,bird_scaled,40,20,60,30);
      fg_drwimage(bird_scaled,60,30);

      { draw 70x35 bird }
      fg_move(162,80);
      fg_scale(bird,bird_scaled,40,20,70,35);
      fg_drwimage(bird_scaled,70,35);

      { draw 80x40 bird }
      fg_move(234,80);
      fg_scale(bird,bird_scaled,40,20,80,40);
      fg_drwimage(bird_scaled,80,40);

      { draw 50x20 bird sheared left horizontally }
      fg_move(55,160);
      fg_shear(bird,bird_scaled,40,20,50,0);
      fg_drwimage(bird_scaled,50,20);

      { draw 50x20 bird sheared right horizontally }
      fg_move(115,160);
      fg_shear(bird,bird_scaled,40,20,50,1);
      fg_drwimage(bird_scaled,50,20);

      { draw 40x30 bird sheared left vertically }
      fg_move(175,160);
      fg_shear(bird,bird_scaled,40,20,30,2);
      fg_drwimage(bird_scaled,40,30);

      { draw 40x30 bird sheared left vertically }
      fg_move(225,160);
      fg_shear(bird,bird_scaled,40,20,30,3);
      fg_drwimage(bird_scaled,40,30);

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Bitmap Scaling and Shearing', { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
