{*****************************************************************************
*                                                                            *
*  SCROLLER.PAS                                                              *
*                                                                            *
*  This program demonstrates circular scrolling within a virtual buffer.     *
*                                                                            *
*  Because fg_scroll() requires a "hidden" virtual buffer to save and then   *
*  restore portions of the area being scrolled, we create a second virtual   *
*  buffer for this purpose.                                                  *
*                                                                            *
*****************************************************************************}

program scroller;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGscroller';
  WIDTH   = 320;
  HEIGHT  = 200;

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb1, hvb2 : integer;

{*****************************************************************************
*                                                                            *
*  The scroll() procedure moves the scrolling region up four pixels in a     *
*  circular manner. It is called from the message loop in WinMain when no    *
*  messages are waiting.                                                     *
*                                                                            *
*****************************************************************************}

procedure scroll;
begin
  fg_scroll(136,184,50,150,-4,0);
  fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb1 := fg_vballoc(WIDTH,HEIGHT);
      hvb2 := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb2);
      fg_vbcolors;
      fg_vbopen(hvb1);
      fg_vbcolors;
      fg_sethpage(hvb2);

      fg_setcolor(19);
      fg_fillpage;
      fg_setcolor(25);
      fg_rect(132,188,50,150);

      fg_setcolor(20);
      fg_move(160,67);
      fg_draw(175,107);
      fg_draw(140,82);
      fg_draw(180,82);
      fg_draw(145,107);
      fg_draw(160,67);
      fg_paint(160,77);
      fg_paint(150,87);
      fg_paint(160,87);
      fg_paint(170,87);
      fg_paint(155,97);
      fg_paint(165,97);

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb1);
      fg_vbfree(hvb2);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Scrolling Demo',           { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  { The message loop processes entries placed in the message queue. }
  { When no message is ready, call scroll() to perform one frame of }
  { animation.                                                      }

  while (TRUE) do
  begin
    if PeekMessage(message,0,0,0,PM_REMOVE) then
    begin
      if message.message = WM_QUIT then
        Exit
      else
      begin
        TranslateMessage(message);
        DispatchMessage(message);
      end;
    end
    else
      scroll;
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
