{*****************************************************************************
*                                                                            *
*  STRINGS1.PAS                                                              *
*                                                                            *
*  This program shows how to display strings in the client area.             *
*                                                                            *
*****************************************************************************}

program strings1;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGstrings1';
  WIDTH   = 320;
  HEIGHT  = 200;

var
  cxClient, cyClient : word;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(24);
      fg_fillpage;
      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
      fg_setcolor(19);

      { upper vertical justification }
      fg_move(fg_xclient(0),fg_yclient(0));
      fg_justify(-1,1);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH div 2),fg_yclient(0));
      fg_justify(0,1);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH-1),fg_yclient(0));
      fg_justify(1,1);
      fg_print('FG/Windows',10);

      { centered vertical justification }
      fg_move(fg_xclient(0),fg_yclient(HEIGHT div 2));
      fg_justify(-1,0);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH div 2),fg_yclient(HEIGHT div 2));
      fg_justify(0,0);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH-1),fg_yclient(HEIGHT div 2));
      fg_justify(1,0);
      fg_print('FG/Windows',10);

      { lower vertical justification }
      fg_move(fg_xclient(0),fg_yclient(HEIGHT-1));
      fg_justify(-1,-1);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH div 2),fg_yclient(HEIGHT-1));
      fg_justify(0,-1);
      fg_print('FG/Windows',10);
      fg_move(fg_xclient(WIDTH-1),fg_yclient(HEIGHT-1));
      fg_justify(1,-1);
      fg_print('FG/Windows',10);

      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Display Strings in Client Area', { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    WIDTH,                      { initial x size }
    HEIGHT,                     { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
