{*****************************************************************************
*                                                                            *
*  SWCHARS.PAS                                                               *
*                                                                            *
*  This program displays all characters in the Fastgraph for Windows primary *
*  and alternate software fonts.                                             *
*                                                                            *
*****************************************************************************}

program swchars;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG, FGWorldG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG, FGWorldG;
{$ENDIF}

const
  AppName = 'FGswchars';
  WIDTH   = 640;
  HEIGHT  = 480;

var
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  xdest, ydest : integer;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_initw;
      fg_setworld(0.0,6.39,0.0,4.79);
      fg_setsizew(0.2);

      fg_setcolor(25);
      fg_fillpage;

      fg_setcolor(19);
      fg_movew(3.2,4.2);
      fg_swchar('Software characters - font 1',28,0);
      fg_setcolor(10);
      fg_movew(0.5,3.9);
      fg_swchar('ABCDEFGHIJKLMNOPQRSTUVWXYZ',26,-1);
      fg_movew(0.5,3.6);
      fg_swchar('abcdefghijklmnopqrstuvwxyz',26,-1);
      fg_movew(0.5,3.3);
      fg_swchar('0123456789',10,-1);
      fg_movew(0.5,3.0);
      fg_swchar('!"#$%&''()*+,-./:;<=>?[]^`{|}~',29,-1);

      fg_setcolor(19);
      fg_movew(3.2,2.5);
      fg_swchar('Software characters - font 2',28,0);
      fg_setcolor(10);
      fg_movew(0.5,2.2);
      fg_swchar('\ABCDEFGHIJKLMNOPRSTUWXYZ',25,-1);
      fg_movew(0.5,1.9);
      fg_swchar('\abcdefghijklmnoprstuwxyz',25,-1);
      fg_movew(0.5,1.3);
      fg_swchar('\012345678#$%&()*+/<=>?[]{}',27,-1);

      fg_setratio(1.2);
      fg_movew(0.5,0.6);
      fg_swchar('cos\^2\h\+sin\^2\h\=1',21,-1);

      fg_movew(5.9,0.6);
      fg_swchar('H\v2O U\v2\v3\v2',16,1);

      fg_setratio(1.0);
      fg_movew(3.2,0.2);
      fg_swchar('One _word_ is underlined.',25,0);

      fg_setcolor(19);
      fg_movew(0.0,2.8);
      fg_draww(6.39,2.8);
      fg_movew(0.0,0.9);
      fg_draww(6.39,0.9);

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,xdest,ydest);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      xdest := (integer(LOWORD(lParam)) - WIDTH) div 2;
      ydest := (integer(HIWORD(lParam)) - HEIGHT) div 2;
      if (xdest < 0) then xdest := 0;
      if (ydest < 0) then ydest := 0;
      ydest := (integer(HIWORD(lParam))-1) - ydest;
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Software Character Set',   { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    WIDTH,                      { initial x size }
    HEIGHT,                     { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
