/****************************************************************************\
*                                                                            *
*  FGWIN.H                                                                   *
*                                                                            *
*  This file contains the C and C++ function prototypes for Fastgraph for    *
*  Windows 1.01.                                                             *
*                                                                            *
*  Copyright (c) 1991-1996 Ted Gruber Software.  All rights reserved.        *
*                                                                            *
\****************************************************************************/

#ifndef __FGWIN_H

#define __FGWIN_H

#ifndef __WINDOWS_H
#include <windows.h>       /* Include WINDOWS.H if not already included */
#endif

#ifdef __BORLANDC__        /* Borland C++ (Win32) */
#ifdef __WIN32__
#define FG32
#endif
#endif

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention("_%r")
#define FG32
#endif

#ifdef _MSC_VER            /* Microsoft Visual C++ 32-bit Edition */
#if _M_IX86 >= 300
#define FG32
#define _export
#endif
#endif

#ifdef __SC__              /* Symantec C++ (Win16 and Win32) */
#ifdef __NT__              /* Symantec C++ (Win32) */
#define FG32
#endif
#endif

#ifdef __WATCOMC__         /* WATCOM C/C++ (Win16 and Win32) */
#ifdef __386__             /* WATCOM C/C++ (Win32) */
#define FG32
#ifdef _export
#undef _export
#define _export
#endif
#endif
#endif

#ifdef FG32                /* data types for Win32 environments */
#define FG_APIENTRY __cdecl
#define byteptr char *
#define dblptr  double *
#define hugeptr char *
#define intptr  int *
#define wordptr short *
#else                      /* data types for Win16 environments */
#define FG_APIENTRY _pascal
#define byteptr char far *
#define dblptr  double far *
#define hugeptr char huge *
#define intptr  int far *
#define wordptr short far *
#endif

#ifdef __cplusplus
extern "C" {
#endif

int      FG_APIENTRY fg_bmphead (byteptr, byteptr);
int      FG_APIENTRY fg_bmppal (byteptr, byteptr);
void     FG_APIENTRY fg_bmpsize (byteptr, intptr, intptr);
void     FG_APIENTRY fg_box (int, int, int, int);
void     FG_APIENTRY fg_boxdepth (int, int);
void     FG_APIENTRY fg_boxw (double, double, double, double);
void     FG_APIENTRY fg_boxx (int, int, int, int);
void     FG_APIENTRY fg_boxxw (double, double, double, double);

void     FG_APIENTRY fg_circle (int);
void     FG_APIENTRY fg_circlef (int);
void     FG_APIENTRY fg_circlefw (double);
void     FG_APIENTRY fg_circlew (double);
int      FG_APIENTRY fg_clip2vb (int, int, int, int, int);
void     FG_APIENTRY fg_clipmap (byteptr, int, int);
void     FG_APIENTRY fg_clipmask (byteptr, int, int);
void     FG_APIENTRY fg_clpimage (byteptr, int, int);
void     FG_APIENTRY fg_clprect (int, int, int, int);
void     FG_APIENTRY fg_clprectw (double, double, double, double);
int      FG_APIENTRY fg_colors (void);
void     FG_APIENTRY fg_copypage (int, int);

void     FG_APIENTRY fg_dash (int, int, int);
void     FG_APIENTRY fg_dashrel (int, int, int);
void     FG_APIENTRY fg_dashrw (double, double, int);
void     FG_APIENTRY fg_dashw (double, double, int);
int      FG_APIENTRY fg_ddflip (void);
void     FG_APIENTRY fg_ddfreedc (HDC);
HDC      FG_APIENTRY fg_ddgetdc (void);
int      FG_APIENTRY fg_ddlock (void);
void     FG_APIENTRY fg_ddsetup (int, int, int, int);
int      FG_APIENTRY fg_ddstatus (void);
void     FG_APIENTRY fg_ddunlock (void);
void     FG_APIENTRY fg_defcolor (int, int);
HPALETTE FG_APIENTRY fg_defpal (void);
void     FG_APIENTRY fg_dispfile (byteptr, int, int);
void     FG_APIENTRY fg_display (byteptr, int, int);
void     FG_APIENTRY fg_displayp (byteptr, int, int);
void     FG_APIENTRY fg_draw (int, int);
void     FG_APIENTRY fg_drawmap (byteptr, int, int);
void     FG_APIENTRY fg_drawmask (byteptr, int, int);
void     FG_APIENTRY fg_drawrel (int, int);
void     FG_APIENTRY fg_drawrelx (int, int);
void     FG_APIENTRY fg_drawrw (double, double);
void     FG_APIENTRY fg_drawrxw (double, double);
void     FG_APIENTRY fg_draww (double, double);
void     FG_APIENTRY fg_drawx (int, int);
void     FG_APIENTRY fg_drawxw (double, double);
void     FG_APIENTRY fg_drect (int, int, int, int, byteptr);
void     FG_APIENTRY fg_drectw (double, double, double, double, byteptr);
void     FG_APIENTRY fg_drwimage (byteptr, int, int);

void     FG_APIENTRY fg_ellipse (int, int);
void     FG_APIENTRY fg_ellipsef (int, int);
void     FG_APIENTRY fg_ellipsew (double, double);
void     FG_APIENTRY fg_ellipsfw (double, double);
void     FG_APIENTRY fg_erase (void);

void     FG_APIENTRY fg_fillpage (void);
int      FG_APIENTRY fg_findrgb (int, int, int);
void     FG_APIENTRY fg_flicdone (byteptr);
int      FG_APIENTRY fg_flichead (byteptr, byteptr);
int      FG_APIENTRY fg_flicopen (byteptr, byteptr);
int      FG_APIENTRY fg_flicplay (byteptr, int, int);
void     FG_APIENTRY fg_flicsize (byteptr, intptr, intptr);
int      FG_APIENTRY fg_flicskip (byteptr, int);
void     FG_APIENTRY fg_flipmask (byteptr, int, int);
void     FG_APIENTRY fg_flood (int, int);
void     FG_APIENTRY fg_floodw (double, double);
void     FG_APIENTRY fg_flpimage (byteptr, int, int);
void     FG_APIENTRY fg_fontdc (HDC);
void     FG_APIENTRY fg_fontload (int);

void     FG_APIENTRY fg_getblock (byteptr, int, int, int, int);
void     FG_APIENTRY fg_getclip (intptr, intptr, intptr, intptr);
long     FG_APIENTRY fg_getclock (void);
int      FG_APIENTRY fg_getcolor (void);
void     FG_APIENTRY fg_getdacs (int, int, byteptr);
HDC      FG_APIENTRY fg_getdc (void);
int      FG_APIENTRY fg_gethpage (void);
void     FG_APIENTRY fg_getimage (byteptr, int, int);
int      FG_APIENTRY fg_getindex (int);
int      FG_APIENTRY fg_getlines (void);
void     FG_APIENTRY fg_getmap (byteptr, int, int);
int      FG_APIENTRY fg_getmaxx (void);
int      FG_APIENTRY fg_getmaxy (void);
int      FG_APIENTRY fg_getpage (void);
int      FG_APIENTRY fg_getpixel (int, int);
void     FG_APIENTRY fg_getrgb (int, intptr, intptr, intptr);
void     FG_APIENTRY fg_getview (intptr, intptr, intptr, intptr, intptr, intptr, intptr, intptr);
void     FG_APIENTRY fg_getworld (dblptr, dblptr, dblptr, dblptr);
int      FG_APIENTRY fg_getxbox (void);
int      FG_APIENTRY fg_getxjust (void);
int      FG_APIENTRY fg_getxpos (void);
int      FG_APIENTRY fg_getybox (void);
int      FG_APIENTRY fg_getyjust (void);
int      FG_APIENTRY fg_getypos (void);

void     FG_APIENTRY fg_imagebuf (byteptr, unsigned);
long     FG_APIENTRY fg_imagesiz (int, int);
void     FG_APIENTRY fg_initw (void);
int      FG_APIENTRY fg_inside (intptr, int, int, int);
void     FG_APIENTRY fg_invert (byteptr, int, int);

void     FG_APIENTRY fg_justify (int, int);

int      FG_APIENTRY fg_kbtest (int);

int      FG_APIENTRY fg_loadpcx (byteptr, int);
void     FG_APIENTRY fg_locate (int, int);
void     FG_APIENTRY fg_logfont (HFONT);
HPALETTE FG_APIENTRY fg_logpal (int, int, byteptr);

int      FG_APIENTRY fg_makebmp (int, int, int, int, int, byteptr);
int      FG_APIENTRY fg_makepcx (int, int, int, int, byteptr);
int      FG_APIENTRY fg_makeppr (int, int, int, int, byteptr);
int      FG_APIENTRY fg_makespr (int, int, int, int, byteptr);
void     FG_APIENTRY fg_mapdacs (byteptr, byteptr, int);
UINT     FG_APIENTRY fg_measure (void);
long     FG_APIENTRY fg_memavail (void);
void     FG_APIENTRY fg_mousecur (HCURSOR);
int      FG_APIENTRY fg_mouseini (void);
void     FG_APIENTRY fg_mouselim (int, int, int, int);
void     FG_APIENTRY fg_mousemov (int, int);
void     FG_APIENTRY fg_mousepos (intptr, intptr);
HCURSOR  FG_APIENTRY fg_mouseptr (wordptr, int, int);
void     FG_APIENTRY fg_mousevis (int);
void     FG_APIENTRY fg_move (int, int);
void     FG_APIENTRY fg_moverel (int, int);
void     FG_APIENTRY fg_moverw (double, double);
void     FG_APIENTRY fg_movew (double, double);

void     FG_APIENTRY fg_pack (byteptr, byteptr, int, int);
long     FG_APIENTRY fg_pagesize (int, int);
void     FG_APIENTRY fg_paint (int, int);
void     FG_APIENTRY fg_paintw (double, double);
int      FG_APIENTRY fg_pcxhead (byteptr, byteptr);
int      FG_APIENTRY fg_pcxpal (byteptr, byteptr);
void     FG_APIENTRY fg_pcxrange (byteptr, intptr, intptr, intptr, intptr);
void     FG_APIENTRY fg_point (int, int);
void     FG_APIENTRY fg_pointw (double, double);
void     FG_APIENTRY fg_pointx (int, int);
void     FG_APIENTRY fg_pointxw (double, double);
void     FG_APIENTRY fg_polyedge (int);
void     FG_APIENTRY fg_polyfill (intptr, intptr, int);
void     FG_APIENTRY fg_polygon (intptr, intptr, int);
void     FG_APIENTRY fg_polygonw (dblptr, dblptr, int);
void     FG_APIENTRY fg_polyline (intptr, int);
void     FG_APIENTRY fg_polyoff (int, int);
void     FG_APIENTRY fg_print (byteptr, int);
int      FG_APIENTRY fg_printer (int);
void     FG_APIENTRY fg_putblock (byteptr, int, int, int, int);
void     FG_APIENTRY fg_putimage (byteptr, int, int);

void     FG_APIENTRY fg_realize (HPALETTE);
void     FG_APIENTRY fg_rect (int, int, int, int);
void     FG_APIENTRY fg_rectw (double, double, double, double);
void     FG_APIENTRY fg_reduce (int, int, byteptr);
void     FG_APIENTRY fg_restore (int, int, int, int);
void     FG_APIENTRY fg_restorew (double, double, double, double);
void     FG_APIENTRY fg_revimage (byteptr, int, int);
void     FG_APIENTRY fg_revmask (byteptr, int, int);

void     FG_APIENTRY fg_save (int, int, int, int);
void     FG_APIENTRY fg_savew (double, double, double, double);
void     FG_APIENTRY fg_scale (byteptr, byteptr, int, int, int, int);
void     FG_APIENTRY fg_scroll (int, int, int, int, int, int);
void     FG_APIENTRY fg_setangle (double);
void     FG_APIENTRY fg_setclip (int, int, int, int);
void     FG_APIENTRY fg_setclipw (double, double, double, double);
void     FG_APIENTRY fg_setcolor (int);
void     FG_APIENTRY fg_setdacs (int, int, byteptr);
void     FG_APIENTRY fg_setdc (HDC);
void     FG_APIENTRY fg_sethpage (int);
void     FG_APIENTRY fg_setpage (int);
void     FG_APIENTRY fg_setratio (double);
void     FG_APIENTRY fg_setrgb (int, int, int, int);
void     FG_APIENTRY fg_setsize (int);
void     FG_APIENTRY fg_setsizew (double);
void     FG_APIENTRY fg_setview (int, int, int, int, int, int, int, int);
void     FG_APIENTRY fg_setworld (double, double, double, double);
void     FG_APIENTRY fg_shear (byteptr, byteptr, int, int, int, int);
int      FG_APIENTRY fg_showbmp (byteptr, int);
int      FG_APIENTRY fg_showflic (byteptr, int, int);
int      FG_APIENTRY fg_showpcx (byteptr, int);
int      FG_APIENTRY fg_showppr (byteptr, int);
int      FG_APIENTRY fg_showspr (byteptr, int);
void     FG_APIENTRY fg_stall (int);
void     FG_APIENTRY fg_swchar (byteptr, int, int);
double   FG_APIENTRY fg_swlength (byteptr, int);
void     FG_APIENTRY fg_swtext (byteptr, int, int);

void     FG_APIENTRY fg_tcdefine (int, int);
void     FG_APIENTRY fg_tcmask (int);
void     FG_APIENTRY fg_tcxfer (int, int, int, int, int, int, int, int);
void     FG_APIENTRY fg_text (byteptr, int);
void     FG_APIENTRY fg_transfer (int, int, int, int, int, int, int, int);

void     FG_APIENTRY fg_unpack (byteptr, byteptr, int);

int      FG_APIENTRY fg_vb2clip (int, int, int, int);
long     FG_APIENTRY fg_vbaddr (int);
int      FG_APIENTRY fg_vballoc (int, int);
void     FG_APIENTRY fg_vbclose (void);
void     FG_APIENTRY fg_vbcolors (void);
void     FG_APIENTRY fg_vbcopy (int, int, int, int, int, int, int, int);
int      FG_APIENTRY fg_vbdefine (hugeptr, int, int);
void     FG_APIENTRY fg_vbfin (void);
void     FG_APIENTRY fg_vbfree (int);
int      FG_APIENTRY fg_vbhandle (void);
void     FG_APIENTRY fg_vbinit (void);
int      FG_APIENTRY fg_vbopen (int);
void     FG_APIENTRY fg_vbpaste (int, int, int, int, int, int);
void     FG_APIENTRY fg_vbprint (int, int, int, int, int, int, int, int, int);
void     FG_APIENTRY fg_vbscale (int, int, int, int, int, int, int, int);
void     FG_APIENTRY fg_vbtccopy (int, int, int, int, int, int, int, int);
void     FG_APIENTRY fg_vbundef (int);
void     FG_APIENTRY fg_version (intptr, intptr);

void     FG_APIENTRY fg_waitfor (int);
void     FG_APIENTRY fg_where (intptr, intptr);

int      FG_APIENTRY fg_xalpha (int);
int      FG_APIENTRY fg_xclient (int);
int      FG_APIENTRY fg_xconvert (int);
int      FG_APIENTRY fg_xscreen (double);
int      FG_APIENTRY fg_xvb (int);
int      FG_APIENTRY fg_xview (int);
double   FG_APIENTRY fg_xworld (int);

int      FG_APIENTRY fg_yalpha (int);
int      FG_APIENTRY fg_yclient (int);
int      FG_APIENTRY fg_yconvert (int);
int      FG_APIENTRY fg_yscreen (double);
int      FG_APIENTRY fg_yvb (int);
int      FG_APIENTRY fg_yview (int);
double   FG_APIENTRY fg_yworld (int);

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention()
#endif

#ifdef __cplusplus
}
#endif

#endif                     /* of #ifndef __FGWIN_H */
