{*****************************************************************************
*                                                                            *
*  BITMAP.DPR                                                                *
*  BITMAPU.PAS                                                               *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows 256-color bitmap      *
*  display functions.                                                        *
*                                                                            *
*****************************************************************************}

unit bitmapU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    drwimage1: TMenuItem;
    clpimage1: TMenuItem;
    revimage1: TMenuItem;
    flpimage1: TMenuItem;
    putimage1: TMenuItem;
    quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure drwimage(Sender: TObject);
    procedure clpimage(Sender: TObject);
    procedure revimage(Sender: TObject);
    procedure flpimage(Sender: TObject);
    procedure putimage(Sender: TObject);
    procedure quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

  { 40x20 256-color bitmapped image of a bird }
  bird : array [1..800] of byte = (
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,10, 0,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,10,25,10,17,10,17,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,10,25,25,10,17,10,17,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   10,25,25,25,25,10,25,10,25,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,
   10,25,25,25,25,10,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,10,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,25,
   10,25,25,25,25,25,25,25,25,10, 0, 0,10,10,10,10,10,17,10, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,
   25,25,25,25,25,25,25,25,10, 0, 0,10,25,25,25,25,25,10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,
   10,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,25,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,10,
   25,25,25,25,25,25,25,25,10,10,25,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
   25,25,25,25,25,25,25,10,25,25,25,25,25,10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,10,25,25,25,25,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,10,10,10, 0, 0, 0, 0, 0,10,25,25,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0,
   10,17,17,17,17,10,10,10,10, 0,10,10,25,25,25,25,25,25,25,25,
   25,25,25,25,25,10,25,25,25,10,10,10,10, 0, 0, 0, 0, 0, 0, 0,
    0,10,17,17,17,17,17,17,17,10,25,25,10,25,25,25,25,25,25,25,
   25,25,25,25,10,25,25,25,10,17,17,17,17,10,10,10,10,10,10, 0,
    0, 0,10,10,10,10,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,25,25,10,14,14,10, 0, 0,
    0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,25,25,25,25,25,25,
   25,25,25,25,25,25,25,25,25,25,25,25,14,25,25,10,10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,25,25,
   25,25,25,25,25,25,25,10,10,10,10,25,25,25,10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,
   10,10,10,10,10,10,10, 0, 0, 0, 0,10,10,10, 0, 0, 0, 0, 0, 0);

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(WIDTH,HEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(20);
  fg_fillpage;

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.drwimage(Sender: TObject);
begin
  fg_fillpage;
  fg_move(VBWIDTH div 2 - 20,VBHEIGHT div 2 + 10);
  fg_drwimage(bird,40,20);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.clpimage(Sender: TObject);
begin
  fg_fillpage;
  fg_move(-20,VBHEIGHT div 2 + 10);
  fg_clpimage(bird,40,20);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.revimage(Sender: TObject);
begin
  fg_fillpage;
  fg_move(VBWIDTH div 2 - 20,VBHEIGHT div 2 + 10);
  fg_revimage(bird,40,20);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.flpimage(Sender: TObject);
begin
  fg_fillpage;
  fg_move(VBWIDTH-20,VBHEIGHT div 2 + 10);
  fg_flpimage(bird,40,20);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.putimage(Sender: TObject);
begin
  fg_fillpage;
  fg_move(VBWIDTH div 2 - 20,VBHEIGHT div 2 + 10);
  fg_putimage(bird,40,20);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.quit(Sender: TObject);
begin
  Halt(1);
end;

end.
