{*****************************************************************************
*                                                                            *
*  BITMAP16.DPR                                                              *
*  BMAP16U.PAS                                                               *
*                                                                            *
*  This program demonstrates how to translate a 16-color bitmap to the 256-  *
*  color format, and display the resulting 256-color image.                  *
*                                                                            *
*****************************************************************************}

unit Bmap16U;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

  { 40x20 pixel (20x20 byte) 16-color bitmapped image of a bird }
  bird16 : array [1..20*20] of byte = (
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$11,$01,$01,$00,$00,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $00,$1F,$17,$17,$11,$00,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $01,$FF,$17,$17,$1F,$10,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
    $1F,$FF,$F1,$F1,$FF,$10,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$01,$11,
    $1F,$FF,$F1,$F1,$F1,$00,$00,$00,$01,$10,
    $00,$00,$00,$00,$00,$00,$00,$00,$1F,$FF,
    $1F,$FF,$FF,$FF,$F1,$00,$11,$11,$17,$10,
    $00,$00,$00,$00,$00,$00,$00,$01,$1F,$F1,
    $FF,$FF,$FF,$FF,$10,$01,$FF,$FF,$F1,$00,
    $00,$00,$00,$00,$00,$00,$00,$1F,$F1,$FF,
    $1F,$FF,$FF,$FF,$10,$1F,$FF,$FF,$10,$00,
    $00,$00,$00,$00,$00,$00,$01,$F1,$FF,$1F,
    $FF,$FF,$FF,$FF,$10,$1F,$FF,$F1,$00,$00,
    $00,$00,$00,$00,$00,$00,$01,$FF,$1F,$F1,
    $FF,$FF,$FF,$FF,$11,$FF,$FF,$10,$00,$00,
    $00,$00,$00,$00,$00,$00,$01,$F1,$FF,$1F,
    $FF,$FF,$FF,$F1,$FF,$FF,$F1,$00,$00,$00,
    $00,$00,$00,$00,$00,$01,$1F,$F1,$FF,$FF,
    $FF,$FF,$FF,$F1,$FF,$1F,$10,$00,$00,$00,
    $00,$00,$00,$00,$00,$1F,$1F,$FF,$FF,$FF,
    $FF,$FF,$FF,$F1,$FF,$FF,$10,$00,$00,$00,
    $01,$11,$10,$00,$00,$1F,$F1,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$F1,$F1,$00,$00,$00,$00,
    $17,$77,$71,$11,$10,$11,$FF,$FF,$FF,$FF,
    $FF,$FF,$F1,$FF,$F1,$11,$10,$00,$00,$00,
    $01,$77,$77,$77,$71,$FF,$1F,$FF,$FF,$FF,
    $FF,$FF,$1F,$FF,$17,$77,$71,$11,$11,$10,
    $00,$11,$11,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$FF,$FF,$FF,$14,$41,$00,
    $00,$00,$00,$11,$11,$11,$11,$FF,$FF,$FF,
    $FF,$FF,$FF,$FF,$FF,$FF,$4F,$F1,$10,$00,
    $00,$00,$00,$00,$00,$00,$00,$11,$FF,$FF,
    $FF,$FF,$FF,$F1,$11,$1F,$FF,$10,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$11,$11,
    $11,$11,$11,$10,$00,$01,$11,$00,$00,$00);

  translation : array [0..15] of byte =
                  (0,10,12,13,14,15,16,17,18,19,20,21,22,23,24,25);

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  bird256 : array [1..40*20] of byte;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i : integer;
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_unpack(bird16,bird256,20*20);
  for i := 1 to 40*20 do
    bird256[i] := translation[bird256[i]];

  fg_setcolor(20);
  fg_fillpage;
  fg_move(VBWIDTH div 2 - 20,VBHEIGHT div 2 + 10);
  fg_drwimage(bird256,40,20);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
{
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
}
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
