{*****************************************************************************
*                                                                            *
*  FONT.DPR                                                                  *
*  FONTU.PAS                                                                 *
*                                                                            *
*  This program shows how use Windows stock fonts in Fastgraph for Windows,  *
*  and also how to create and use a Windows logical font. The logical font   *
*  is a 24x12 script font.                                                   *
*                                                                            *
*****************************************************************************}

unit FontU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hfnt : hFont;
  hpal : hPalette;
  hvb  : integer;
  lf   : tLogfont;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(24);
  fg_fillpage;

  lf.lfHeight := 24;                { character height in pixels }
  lf.lfWidth := 12;                 { character width in pixels }
  lf.lfEscapement := 0;             { orientation of next character }
  lf.lfOrientation := 0;            { orientation of first character }
  lf.lfWeight := FW_NORMAL;         { normal thickness }
  lf.lfItalic := 0;                 { not italic characters }
  lf.lfUnderline := 0;              { not underlined characters }
  lf.lfStrikeOut := 0;              { not strikeout characters }
  lf.lfCharSet := OEM_CHARSET;      { OEM character set }
  lf.lfOutPrecision := 0;           { default output precision }
  lf.lfClipPrecision := 0;          { default clipping precision }
  lf.lfQuality := DEFAULT_QUALITY;  { default scaling quality }
  lf.lfPitchAndFamily := FF_SCRIPT; { default pitch, script font family }
  lstrcpy(lf.lfFaceName,'script'+chr(0)); { script typeface }
  hfnt := CreateFontIndirect(lf);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  x : integer;
begin
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
  fg_setcolor(19);
  x := fg_xclient(20);

  fg_move(x,fg_yclient(20));
  fg_fontload(10);
  fg_print('OEM fixed font',14);

  fg_move(x,fg_yclient(40));
  fg_fontload(11);
  fg_print('ANSI fixed font',15);

  fg_move(x,fg_yclient(60));
  fg_fontload(12);
  fg_print('ANSI var font',13);

  fg_move(x,fg_yclient(80));
  fg_fontload(13);
  fg_print('system font',11);

  fg_move(x,fg_yclient(100));
  fg_fontload(14);
  fg_print('device default font',19);

  fg_move(x,fg_yclient(120));
  fg_fontload(16);
  fg_print('system fixed font',17);

  fg_move(x,fg_yclient(160));
  fg_logfont(hfnt);
  fg_print('script font',11);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hfnt);
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
