{*****************************************************************************
*                                                                            *
*  FULLSCR.DPR                                                               *
*  FULLSCRU.PAS                                                              *
*                                                                            *
*  This program shows how to set up a full screen DirectDraw application     *
*  for either blitting or flipping. The selection of blitting or flipping is *
*  controlled by the BLIT and FLIP symbols defined below.                    *
*                                                                            *
*****************************************************************************}

unit fullscru;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWinD;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure AppOnDeactivate(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ define either BLIT or FLIP, but not both, for blitting or flipping }
{$DEFINE BLIT}
{$UNDEF FLIP}

const
  vbWidth = 640;
  vbHeight = 480;
var
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  AppIsActive : boolean;

{*****************************************************************************
*                                                                            *
*  Animate                                                                   *
*                                                                            *
*  Construct the next frame of animation and display it with either blitting *
*  or flipping, as directed by the BLIT and FLIP symbols above.              *
*                                                                            *
*****************************************************************************}

procedure Animate;
var
  color : integer;
begin
  { fill drawing surface with the next color }
  color := fg_getcolor + 1;
  if color > 255 then color := 0;
  fg_setcolor(color);
  fg_fillpage;

  { blit or flip surface to the screen }
  {$IFDEF BLIT}
  fg_vbpaste(0,vbWidth-1,0,vbHeight-1,0,vbHeight-1);
  {$ENDIF}
  {$IFDEF FLIP}
  fg_ddflip;
  {$ENDIF}
end;

{*****************************************************************************
*                                                                            *
*  Application event handlers...                                             *
*                                                                            *
*****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  AppIsActive := True;
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.AppOnDeactivate(Sender: TObject);
begin
  AppIsActive := False;
end;

procedure TForm1.AppIdle(Sender: Tobject; var Done: Boolean);
begin
  if AppIsActive then Animate;
  Done := False;
end;

{*****************************************************************************
*                                                                            *
*  Form event handlers...                                                    *
*                                                                            *
*****************************************************************************}

procedure TForm1.FormActivate(Sender: TObject);
begin
  { define the DirectDraw video mode and initialize the Fastgraph for }
  { Windows virtual buffer environment for that mode }
  {$IFDEF BLIT}
  fg_ddsetup(vbWidth,vbHeight,8,0);
  {$ENDIF}
  {$IFDEF FLIP}
  fg_ddsetup(vbWidth,vbHeight,8,1);
  {$ENDIF}
  fg_vbinit;
  if fg_ddstatus <> 0 then
  begin
     Application.MessageBox('DirectDraw init failed','FIRST',
                            mb_iconstop or mb_ok);
     Halt(1);
  end;

  { if blitting, create a virtual buffer the same size as the screen }
  { resolution; if flipping, use the primary surface's back buffer }
  {$IFDEF BLIT}
  hvb := fg_vballoc(vbWidth,vbHeight);
  {$ENDIF}
  {$IFDEF FLIP}
  hvb := 0;
  {$ENDIF}
  fg_vbopen(hvb);
  fg_vbcolors;
  fg_realize(hpal);

  { hide the mouse cursor }
  fg_mouseini;
  fg_mousevis(0);

  AppIsActive := True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  AppIsActive := False;
  Application.OnActivate := AppOnActivate;
  Application.OnDeactivate := AppOnDeactivate;
  Application.OnIdle := AppIdle;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = Chr(27) then Halt(1);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_mousevis(1);
  fg_vbclose;
  {$IFDEF BLIT}
  fg_vbfree(hvb);
  {$ENDIF}
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
