{*****************************************************************************
*                                                                            *
*  GDIDEMO.DPR                                                               *
*  GDIDEMOU.PAS                                                              *
*                                                                            *
*  This program shows how to use Windows GDI functions to write to a virtual *
*  buffer. It uses GDI functions to display a cross-hatched rectangle with a *
*  border, something that would require construction from several graphics   *
*  primitives if using Fastgraph for Windows drawing functions only.         *
*                                                                            *
*  Only the Fastgraph for Windows WinG support libraries allow writing to a  *
*  virtual buffer with GDI functions.                                        *
*                                                                            *
*****************************************************************************}

unit GDIdemoU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWinG;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  brush : hBrush;
  hDIB  : hDC;
  pen   : hPen;
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(320,200);
  fg_vbopen(hvb);
  fg_vbcolors;

  { use FG to fill the virtual buffer with light green pixels }
  fg_setcolor(20);
  fg_fillpage;

  { fg_getdc() returns the WinG device context to which the GDI
    functions will draw, or zero if WinG is not available }
  hDIB := fg_getdc;
  if (hDIB = 0) then
  begin
    Application.MessageBox('WinG not available!','GDIDEMO',MB_ICONSTOP OR MB_OK);
    Halt(255);
  end;

  { use Windows GDI functions to display a cross-hatched
    rectangle with blue border in the virtual buffer }
  pen := CreatePen(PS_SOLID,3,RGB(0,0,255));
  brush := CreateHatchBrush(HS_DIAGCROSS,RGB(255,0,0));
  SelectObject(hDIB,pen);
  SelectObject(hDIB,brush);
  Rectangle(hDIB,20,20,50,50);
  DeleteObject(pen);
  DeleteObject(brush);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
