{*****************************************************************************
*                                                                            *
*  GRAPHIC.DPR                                                               *
*  GRAPHICU.PAS                                                              *
*                                                                            *
*  This program demonstrates some of the Fastgraph for Windows graphics      *
*  primitive functions.                                                      *
*                                                                            *
*****************************************************************************}

unit graphicU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Points1: TMenuItem;
    Lines1: TMenuItem;
    Rectangles1: TMenuItem;
    Circles1: TMenuItem;
    Ellipses1: TMenuItem;
    Polygons1: TMenuItem;
    Paint1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure points(Sender: TObject);
    procedure Lines(Sender: TObject);
    procedure rectangles(Sender: TObject);
    procedure Circles(Sender: TObject);
    procedure Ellipses(Sender: TObject);
    procedure Polygons(Sender: TObject);
    procedure Paint(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 640;
  VBHEIGHT = 480;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

{*****************************************************************************
*                                                                            *
*  blit                                                                      *
*                                                                            *
*  Use fg_vbpaste() or fg_vbscale() to display the virtual buffer contents   *
*  in the client area, depending on the size of the client window.           *
*                                                                            *
*****************************************************************************}

procedure blit;

begin
  if (cxClient > VBWIDTH) OR (cyClient > VBHEIGHT) then {window larger than 640x480}
    fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1)
  else
    fg_vbpaste(0,VBWIDTH-1,0,VBHEIGHT-1,0,cyClient-1);
end;

{*****************************************************************************
*                                                                            *
*  do_circles                                                                *
*                                                                            *
*  Draw a series of concentric circles.                                      *
*                                                                            *
*****************************************************************************}

procedure do_circles;

var
  i, radius : integer;

begin
  fg_setcolor(11);
  fg_fillpage;

  { draw 25 concentric circles at the center of the virtual buffer }

  fg_move(VBWIDTH div 2,VBHEIGHT div 2);
  radius := 4;
  fg_setcolor(25);
  for i := 1 to 25 do
  begin
    fg_circle(radius);
    inc(radius,8);
  end;

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_ellipses                                                               *
*                                                                            *
*  Draw a series of concentric ellipses.                                     *
*                                                                            *
*****************************************************************************}

procedure do_ellipses;

var
  i, horiz, vert : integer;

begin
  fg_setcolor(11);
  fg_fillpage;

  { draw 80 concentric ellipses at the center of the virtual buffer }

  fg_move(VBWIDTH div 2,VBHEIGHT div 2);
  horiz := 4;
  vert  := 1;
  fg_setcolor(25);
  for i := 1 to 80 do
  begin
    fg_ellipse(horiz,vert);
    inc(horiz,3);
    inc(vert);
  end;

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_lines                                                                  *
*                                                                            *
*  Draw a pattern of solid lines.                                            *
*                                                                            *
*****************************************************************************}

procedure do_lines;

const
   line_color : array [0..7] of integer = (12,11,19,21,21,19,11,12);

var
   i, x, y, x1, x2, y1 : integer;

begin
  fg_setcolor(25);
  fg_fillpage;

  { draw horizontal lines }

  y := 0;
  while (y < VBHEIGHT) do
  begin
    for i := 0 to 7 do
    begin
      fg_setcolor(line_color[i]);
      y1 := y + 3*i;
      fg_move(0,y1);
      fg_draw(VBWIDTH-1,y1);
    end;
    inc(y,40);
  end;

  { draw vertical lines }

  x := 0;
  while (x < VBWIDTH) do
  begin
    for i := 0 to 7 do
    begin
      fg_setcolor(line_color[i]);
      x1 := x + 3*i;
      fg_move(x1,0);
      fg_draw(x1,VBHEIGHT-1);
    end;
    inc(x,60);
  end;

  { draw red diagonal lines }

  fg_setcolor(22);
  x1 := -640;
  while (x1 < 640) do
  begin
    x2 := x1 + VBHEIGHT;
    fg_move(x1,0);
    fg_draw(x2,VBHEIGHT);
    inc(x1,60);
  end;
  x1 := 0;
  while (x1 < 1280) do
  begin
    x2 := x1 - VBHEIGHT;
    fg_move(x1,0);
    fg_draw(x2,VBHEIGHT);
    inc(x1,60);
  end;

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_paint                                                                  *
*                                                                            *
*  Demonstrate region fill.                                                  *
*                                                                            *
*****************************************************************************}

procedure do_paint;

var
  x1, x2, y1, y2 : integer;

begin
  fg_setcolor(25);
  fg_fillpage;

  { draw a rectangle }

  x1 := 40;
  x2 := VBWIDTH - 40;
  y1 := 20;
  y2 := VBHEIGHT - 20;
  fg_setcolor(21);
  fg_rect(x1,x2,y1,y2);

  { outline the rectangle }

  fg_setcolor(10);
  fg_box(x1,x2,y1,y2);

  { draw the circle }

  x1 := VBWIDTH div 2;
  y1 := VBHEIGHT div 2;
  fg_move(x1,y1);
  fg_circle(80);

  { draw cross bars in the circle }

  fg_move(x1,y1-80);
  fg_draw(x1,y1+80);
  fg_move(x1-80,y1);
  fg_draw(x1+80,y1);

  { paint each quarter of the circle }

  fg_setcolor(11);
  fg_paint(x1-6,y1-6);
  fg_setcolor(12);
  fg_paint(x1+6,y1+6);
  fg_setcolor(13);
  fg_paint(x1+6,y1-6);
  fg_setcolor(14);
  fg_paint(x1-6,y1+6);

  { paint the area outside the box }

  fg_setcolor(24);
  fg_paint(41,21);

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_points                                                                 *
*                                                                            *
*  Draw a pattern of points.                                                 *
*                                                                            *
*****************************************************************************}

procedure do_points;

var
  x, y : integer;

begin
  { fill the virtual buffer with blue pixels }

  fg_setcolor(24);
  fg_fillpage;

  { draw the patterns of points }

  fg_setcolor(19);
  x := 7;
  while (x < VBWIDTH) do
  begin
    y := 0;
    while (y < VBHEIGHT) do
    begin
      fg_point(x,y);
      inc(y,8);
    end;
    inc(x,20);
  end;

  fg_setcolor(22);
  x := 17;
  while (x < VBWIDTH) do
  begin
    y := 4;
    while (y < VBHEIGHT) do
    begin
      fg_point(x,y);
      inc(y,8);
    end;
    inc(x,20);
  end;

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_polygons                                                               *
*                                                                            *
*  Draw a grid of filled polygons.                                           *
*                                                                            *
*****************************************************************************}

procedure do_polygons;

const
   xy_dkblue  : array[0..7] of integer = (0,16, 24,0, 24,40, 0,56);
   xy_ltblue  : array[0..7] of integer = (24,0, 72,0, 72,40, 24,40);
   xy_magenta : array[0..7] of integer = (0,56, 24,40, 72,40, 48,56);

var
   work_array : array [1..57*2] of integer;
   i, j : integer;

begin
  fg_setcolor(25);
  fg_fillpage;

  { draw 225 filled polygons (15 rows of 15) }

  for j := 0 to 14 do
  begin
    for i := 0 to 14 do
    begin
      fg_polyoff(i*72-j*24,j*56-i*16);
      fg_setcolor(11);
      fg_polyfill(xy_dkblue,work_array,4);
      fg_setcolor(19);
      fg_polyfill(xy_ltblue,work_array,4);
      fg_setcolor(20);
      fg_polyfill(xy_magenta,work_array,4);
    end;
  end;

  blit;
end;

{*****************************************************************************
*                                                                            *
*  do_rectangles                                                             *
*                                                                            *
*  Draw a grid of filled rectangles.                                         *
*                                                                            *
*****************************************************************************}

procedure do_rectangles;

var
   i, j, color : integer;
   x1, x2, y1, y2 : integer;
   xinc, yinc : integer;

begin
  x1 := 0;
  xinc := VBWIDTH div 10;
  x2 := xinc - 1;

  y1 := 0;
  yinc := VBHEIGHT div 10;
  y2 := yinc - 1;

  color := 10;

  { draw 100 filled rectangles (10 rows of 10) }

  for i := 1 to 10 do
  begin
    for j := 1 to 10 do
    begin
      fg_setcolor(color);
      fg_rect(x1,x2,y1,y2);
      inc(color);
      if (color > 24) then color := 10;
      inc(x1,xinc);
      inc(x2,xinc);
    end;
    x1 := 0;
    x2 := xinc - 1;
    inc(y1,yinc);
    inc(y2,yinc);
  end;

  blit;
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(25);
  fg_fillpage;

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  blit;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.points(Sender: TObject);
begin
  do_points;
end;

procedure TForm1.Lines(Sender: TObject);
begin
  do_lines;
end;

procedure TForm1.rectangles(Sender: TObject);
begin
  do_rectangles;
end;

procedure TForm1.Circles(Sender: TObject);
begin
  do_circles;
end;

procedure TForm1.Ellipses(Sender: TObject);
begin
  do_ellipses;
end;

procedure TForm1.Polygons(Sender: TObject);
begin
  do_polygons;
end;

procedure TForm1.Paint(Sender: TObject);
begin
  do_paint;
end;

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
