{*****************************************************************************
*                                                                            *
*  KBDEMO.DPR                                                                *
*  KBDEMOU.PAS                                                               *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window using the low-level keyboard handler.                    *
*                                                                            *
*****************************************************************************}

unit kbdemoU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 640;
  VBHEIGHT = 480;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  x, y : integer;
  xlimit, ylimit : integer;
  CanGoLeft, CanGoRight, CanGoUp, CanGoDown : boolean;

{*****************************************************************************
*                                                                            *
*  The check_for_panning() function checks if any of the four arrow keys are *
*  pressed, and if so, pans in that direction if possible. It is called from *
*  the application's OnIdle event handler.                                   *
*                                                                            *
*****************************************************************************}

procedure check_for_panning;

const
  KB_ESCAPE =  1;
  KB_LEFT   = 75;
  KB_RIGHT  = 77;
  KB_UP     = 72;
  KB_DOWN   = 80;

begin
  if (fg_kbtest(KB_LEFT) = 1) and CanGoLeft then
  begin
    if (x = 0) then CanGoRight := TRUE;
    inc(x);
    fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
    if (x = xlimit) then CanGoLeft := FALSE;
  end

  else if (fg_kbtest(KB_RIGHT) = 1) and CanGoRight then
  begin
    if (x = xlimit) then CanGoLeft := TRUE;
    dec(x);
    fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
    if (x = 0) then CanGoRight := FALSE;
  end

  else if (fg_kbtest(KB_UP) = 1) and CanGoUp then
  begin
    if (y = 0) then CanGoDown := TRUE;
    inc(y);
    fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
    if (y = ylimit) then CanGoUp := FALSE;
  end

  else if (fg_kbtest(KB_DOWN) = 1) and CanGoDown then
  begin
    if (y = ylimit) then CanGoUp := TRUE;
    dec(y);
    fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
    if (y = 0) then CanGoDown := FALSE;
  end

  else if (fg_kbtest(KB_ESCAPE) = 1) then
  begin
    x := 0;
    y := 0;
    fg_vbpaste(0,VBWIDTH-1,0,VBHEIGHT-1,0,VBHEIGHT-1);
    if (xlimit > 0) then CanGoLeft := TRUE;
    if (ylimit > 0) then CanGoUp := TRUE;
    CanGoRight := FALSE;
    CanGoDown  := FALSE;
  end;
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.AppIdle(Sender: Tobject; var Done: Boolean);
begin
  check_for_panning;
  Done := False;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_showbmp('PORCH.BMP'+chr(0),0);
  x := 0;
  y := 0;
  CanGoLeft  := TRUE;
  CanGoUp    := TRUE;
  CanGoRight := FALSE;
  CanGoDown  := FALSE;

  Application.OnActivate := AppOnActivate;
  Application.OnIdle := AppIdle;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;

  if (cxClient < VBWIDTH) then
  begin
    xlimit := VBWIDTH - cxClient;
    if (x < xlimit) then CanGoLeft := TRUE;
    if (x > 0)      then CanGoRight := TRUE;
  end
  else
  begin
    xlimit := 0;
    CanGoLeft  := FALSE;
    CanGoRight := FALSE;
  end;

  if (cyClient < VBHEIGHT) then
  begin
    ylimit := VBHEIGHT - cyClient;
    if (y < ylimit) then CanGoUp := TRUE;
    if (y > 0)      then CanGoDown := TRUE;
  end
  else
  begin
    ylimit := 0;
    CanGoUp   := FALSE;
    CanGoDown := FALSE;
  end;

  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
