{*****************************************************************************
*                                                                            *
*  MCDEMO.DPR                                                                *
*  MCDEMOU.PAS                                                               *
*                                                                            *
*  This program shows how to change the shape of the mouse cursor.           *
*                                                                            *
*****************************************************************************}

unit mcdemoU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

  cross : array [1..32] of word = (
              $E03F,$E03F,$E03F,$0007,$0007,$0007,$0007,$0007,
              $0007,$0007,$E03F,$E03F,$E03F,$FFFF,$FFFF,$FFFF,
              $0000,$0F80,$0F80,$0F80,$7FF0,$7FF0,$7FF0,$7FF0,
              $7FF0,$0F80,$0F80,$0F80,$0000,$0000,$0000,$0000);
var
  cxClient, cyClient : integer;
  cursor : hCursor;
  dc     : hDC;
  hpal   : hPalette;
  hvb    : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(20);
  fg_fillpage;

  fg_mouseini;
  cursor := fg_mouseptr(cross,6,6);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  fg_mousecur(cursor);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DestroyCursor(cursor);
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
