{*****************************************************************************
*                                                                            *
*  MONOMAP.DPR                                                               *
*  MONOMAPU.PAS                                                              *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows monochrome bitmap     *
*  display functions.                                                        *
*                                                                            *
*****************************************************************************}

unit monomapU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    drawmap1: TMenuItem;
    clipmap1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure drawmap(Sender: TObject);
    procedure clipmap(Sender: TObject);
    procedure quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

  hello : array [1..40] of byte = (
    $00,$00,$00,$00,$00,
    $CC,$78,$78,$78,$78,
    $CC,$C0,$30,$30,$CC,
    $CC,$FC,$30,$30,$CC,
    $FC,$CC,$30,$30,$CC,
    $CC,$78,$30,$30,$78,
    $CC,$00,$30,$30,$00,
    $CC,$00,$70,$70,$00);

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(25);
  fg_fillpage;

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.drawmap(Sender: TObject);
begin
  fg_setcolor(25);
  fg_fillpage;
  fg_setcolor(10);
  fg_move(VBWIDTH div 2 - 20,VBHEIGHT div 2 + 4);
  fg_drawmap(hello,5,8);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.clipmap(Sender: TObject);
begin
  fg_setcolor(25);
  fg_fillpage;
  fg_setcolor(22);
  fg_move(-12,VBHEIGHT div 2 + 4);
  fg_clipmap(hello,5,8);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.quit(Sender: TObject);
begin
  Halt(1);
end;

end.
