{*****************************************************************************
*                                                                            *
*  PANNER.DPR                                                                *
*  PANNERU.PAS                                                               *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window.                                                         *
*                                                                            *
*****************************************************************************}

unit pannerU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Left1: TMenuItem;
    Right1: TMenuItem;
    Up1: TMenuItem;
    Down1: TMenuItem;
    Reset1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure left(Sender: TObject);
    procedure Right(Sender: TObject);
    procedure Up(Sender: TObject);
    procedure Down(Sender: TObject);
    procedure Reset(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 640;
  VBHEIGHT = 480;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  x, y : integer;
  xlimit, ylimit : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_showbmp('PORCH.BMP'+chr(0),0);
  x := 0;
  y := 0;

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;

  if (cxClient < VBWIDTH) then
  begin
    xlimit := VBWIDTH - cxClient;
    if (x < xlimit) then Form1.Left1.Enabled  := True;
    if (x > 0)      then Form1.Right1.Enabled := True;
  end
  else
  begin
    xlimit := 0;
    Form1.Left1.Enabled  := False;
    Form1.Right1.Enabled := False;
  end;

  if (cyClient < VBHEIGHT) then
  begin
    ylimit := VBHEIGHT - cyClient;
    if (y < ylimit) then Form1.Up1.Enabled   := True;
    if (y > 0)      then Form1.Down1.Enabled := True;
  end
  else
  begin
    ylimit := 0;
    Form1.Up1.Enabled   := False;
    Form1.Down1.Enabled := False;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.left(Sender: TObject);
begin
  if (x = 0) then Form1.Right1.Enabled := True;
  inc(x);
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
  if (x = xlimit) then Form1.Left1.Enabled := False;
end;

procedure TForm1.Right(Sender: TObject);
begin
  if (x = xlimit) then Form1.Left1.Enabled := True;
  dec(x);
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
  if (x = 0) then Form1.Right1.Enabled := False;
end;

procedure TForm1.Up(Sender: TObject);
begin
  if (y = 0) then Form1.Down1.Enabled := True;
  inc(y);
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
  if (y = ylimit) then Form1.Up1.Enabled := False;
end;

procedure TForm1.Down(Sender: TObject);
begin
  if (y = ylimit) then Form1.Up1.Enabled := True;
  dec(y);
  fg_vbpaste(x,x+(VBWIDTH-1),y,y+(VBHEIGHT-1),0,VBHEIGHT-1);
  if (y = 0) then Form1.Down1.Enabled := False;
end;

procedure TForm1.Reset(Sender: TObject);
begin
  x := 0;
  y := 0;
  fg_vbpaste(0,VBWIDTH-1,0,VBHEIGHT-1,0,VBHEIGHT-1);
  if (xlimit > 0) then Form1.Left1.Enabled := True;
  if (ylimit > 0) then Form1.Up1.Enabled   := True;
  Form1.Right1.Enabled := False;
  Form1.Down1.Enabled  := False;
end;

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
