{*****************************************************************************
*                                                                            *
*  PCXFLIP.DPR                                                               *
*  PCXFLIPU.PAS                                                              *
*                                                                            *
*  This program displays a 320x200 PCX file mirrored about the y-axis using  *
*  the bitmap display routines.                                              *
*                                                                            *
*****************************************************************************}

unit PCXflipU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  bitmap : pointer;
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_showpcx('MOUSE.PCX'+chr(0),2);

  bitmap := GlobalAllocPtr(GMEM_MOVEABLE,fg_imagesiz(VBWIDTH,VBHEIGHT));
  fg_move(0,VBHEIGHT-1);
  fg_getimage(bitmap^,VBWIDTH,VBHEIGHT);
  fg_revimage(bitmap^,VBWIDTH,VBHEIGHT);
  GlobalFreePtr(bitmap);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
