{*****************************************************************************
*                                                                            *
*  PRDEMO.DPR                                                                *
*  PRDEMOU.PAS                                                               *
*                                                                            *
*  This program shows how to print the contents of a virtual buffer.  It     *
*  first loads a 640x480 BMP file into a virtual buffer and displays it.     *
*  When the user clicks the Print selection on the top-level menu, a 6-inch  *
*  by 4-inch copy of the BMP image is sent to the default printer.           *
*                                                                            *
*****************************************************************************}

unit prdemoU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Print1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Print(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 640;
  VBHEIGHT = 480;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_showbmp('PORCH.BMP'+chr(0),0);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.Print(Sender: TObject);
begin
  if (fg_printer(10) = 0) then
  begin
    fg_vbprint(0,VBWIDTH-1,0,VBHEIGHT-1,0,600,0,400,2);
    fg_printer(1);
    fg_printer(11);
  end
  else
    Application.MessageBox('Printer setup failed','PRDEMO',MB_ICONSTOP OR MB_OK);
end;

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
