{*****************************************************************************
*                                                                            *
*  RAINBOW.DPR                                                               *
*  RAINBOWU.PAS                                                              *
*                                                                            *
*  This program demonstrates color palette cycling.                          *
*                                                                            *
*****************************************************************************}

unit RainbowU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
var
  cxClient, cyClient : integer;
  dc    : hDC;
  hpal  : hPalette;
  hvb   : integer;
  start : integer;
  RGBvalues : array [0..2*24*3-1] of byte;    { two sets of 24 RGB triplets }

{*****************************************************************************
*                                                                            *
*  fill_color_palette                                                        *
*                                                                            *
*  Set up the colors for the application's logical palette in the RGBvalues  *
*  array. The logical palette will contain 24 non-system colors (indices 10  *
*  to 33) defining the initial RGB values for the colors being cycled.       *
*                                                                            *
*  Note that we store two identical sets of 24 RGB triplets in RGBvalues. We *
*  can then perform color cycling without having to worry about wrapping to  *
*  the start of the array because the index pointing to the starting RGB     *
*  triplet never extends beyond the first set of 24 RGB triplets.            *
*                                                                            *
*****************************************************************************}

procedure fill_color_palette;

const
  colors : array [1..24*3] of byte = (
    182,182,255, 198,182,255, 218,182,255, 234,182,255, 255,182,255,
    255,182,234, 255,182,218, 255,182,198, 255,182,182, 255,198,182,
    255,218,182, 255,234,182, 255,255,182, 234,255,182, 218,255,182,
    198,255,182, 182,255,182, 182,255,198, 182,255,218, 182,255,234,
    182,255,255, 182,234,255, 182,218,255, 182,198,255);

begin
   { set up two identical sets of the 24 colors in the RGBvalues array }
   Move(colors,RGBvalues,24*3);
   Move(colors,RGBvalues[24*3],24*3);
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  color, xlen, ylen : integer;
begin

  { create the logical palette }

  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  fill_color_palette;
  hpal := fg_logpal(10,24,RGBvalues);
  fg_realize(hpal);

  { create a 640x480 virtual buffer }

  fg_vbinit;
  hvb := fg_vballoc(640,480);
  fg_vbopen(hvb);
  fg_vbcolors;

  { construct a crude image of a rainbow }

  fg_setcolor(255);
  fg_fillpage;
  fg_setclip(0,639,0,300);
  fg_move(320,300);
  xlen := 240;
  ylen := 120;
  for color := 10 to 33 do
  begin
    fg_setcolor(color);
    fg_ellipsef(xlen,ylen);
    dec(xlen,4);
    dec(ylen,3);
  end;
  fg_setcolor(255);
  fg_ellipsef(xlen,ylen);
  fg_setclip(0,639,0,479);

  { starting index into the array of color values }

  start := 0;

  Application.OnActivate := AppOnActivate;
  Timer1.Interval := 50;
  Timer1.Enabled  := True;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if (GetActiveWindow = Form1.Handle) then
  begin
    start := (start + 3) mod 72;
    fg_setdacs(10,24,RGBvalues[start]);
    if (fg_colors > 8) then
      fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
  end;
end;

end.
