{*****************************************************************************
*                                                                            *
*  SCALE.DPR                                                                 *
*  SCALEU.PAS                                                                *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows 256-color bitmap      *
*  scaling and shearing functions.                                           *
*                                                                            *
*****************************************************************************}

unit ScaleU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

  { 40x20 256-color bitmapped image of a bird }
  bird : array [1..40*20] of byte = (
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0,10,10, 0,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0,10,25,10,17,10,17,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0,10,25,25,10,17,10,17,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    10,25,25,25,25,10,25,10,25,25,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,
    10,25,25,25,25,10,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,10,10, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,25,
    10,25,25,25,25,25,25,25,25,10, 0, 0,10,10,10,10,10,17,10, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,
    25,25,25,25,25,25,25,25,10, 0, 0,10,25,25,25,25,25,10, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,
    10,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,25,10, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
    25,25,25,25,25,25,25,25,10, 0,10,25,25,25,25,10, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,25,10,25,25,10,
    25,25,25,25,25,25,25,25,10,10,25,25,25,25,10, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,10,25,
    25,25,25,25,25,25,25,10,25,25,25,25,25,10, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,10,25,25,25,25,
    25,25,25,25,25,25,25,10,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,25,10,25,25,25,25,25,25,25,
    25,25,25,25,25,25,25,10,25,25,25,25,10, 0, 0, 0, 0, 0, 0, 0,
     0,10,10,10,10, 0, 0, 0, 0, 0,10,25,25,10,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,10,25,10, 0, 0, 0, 0, 0, 0, 0, 0,
    10,17,17,17,17,10,10,10,10, 0,10,10,25,25,25,25,25,25,25,25,
    25,25,25,25,25,10,25,25,25,10,10,10,10, 0, 0, 0, 0, 0, 0, 0,
     0,10,17,17,17,17,17,17,17,10,25,25,10,25,25,25,25,25,25,25,
    25,25,25,25,10,25,25,25,10,17,17,17,17,10,10,10,10,10,10, 0,
     0, 0,10,10,10,10,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,25,25,25,25,25,10,14,14,10, 0, 0,
     0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,25,25,25,25,25,25,
    25,25,25,25,25,25,25,25,25,25,25,25,14,25,25,10,10, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,25,25,25,25,
    25,25,25,25,25,25,25,10,10,10,10,25,25,25,10, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,
    10,10,10,10,10,10,10, 0, 0, 0, 0,10,10,10, 0, 0, 0, 0, 0, 0);

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

  { scaled/sheared bird bitmap (80x40 max) }
  bird_scaled : array [1..80*40] of byte;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(20);
  fg_fillpage;

  { draw 40x20 bird (original bitmap) }
  fg_move(6,80);
  fg_drwimage(bird,40,20);

  { draw 50x25 bird }
  fg_move(48,80);
  fg_scale(bird,bird_scaled,40,20,50,25);
  fg_drwimage(bird_scaled,50,25);

  { draw 60x30 bird }
  fg_move(100,80);
  fg_scale(bird,bird_scaled,40,20,60,30);
  fg_drwimage(bird_scaled,60,30);

  { draw 70x35 bird }
  fg_move(162,80);
  fg_scale(bird,bird_scaled,40,20,70,35);
  fg_drwimage(bird_scaled,70,35);

  { draw 80x40 bird }
  fg_move(234,80);
  fg_scale(bird,bird_scaled,40,20,80,40);
  fg_drwimage(bird_scaled,80,40);

  { draw 50x20 bird sheared left horizontally }
  fg_move(55,160);
  fg_shear(bird,bird_scaled,40,20,50,0);
  fg_drwimage(bird_scaled,50,20);

  { draw 50x20 bird sheared right horizontally }
  fg_move(115,160);
  fg_shear(bird,bird_scaled,40,20,50,1);
  fg_drwimage(bird_scaled,50,20);

  { draw 40x30 bird sheared left vertically }
  fg_move(175,160);
  fg_shear(bird,bird_scaled,40,20,30,2);
  fg_drwimage(bird_scaled,40,30);

  { draw 40x30 bird sheared left vertically }
  fg_move(225,160);
  fg_shear(bird,bird_scaled,40,20,30,3);
  fg_drwimage(bird_scaled,40,30);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
