{*****************************************************************************
*                                                                            *
*  SCROLL.DPR                                                                *
*  SCROLLU.PAS                                                               *
*                                                                            *
*  This program demonstrates circular scrolling within a virtual buffer.     *
*                                                                            *
*  Because fg_scroll() requires a "hidden" virtual buffer to save and then   *
*  restore portions of the area being scrolled, we create a second virtual   *
*  buffer for this purpose.                                                  *
*                                                                            *
*****************************************************************************}

unit scrollU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb1, hvb2 : integer;

{*****************************************************************************
*                                                                            *
*  The do_scroll() procedure moves the scrolling region up four pixels in    *
*  a circular manner. It is called from the application's OnIdle event       *
*  handler.                                                                  *
*                                                                            *
*****************************************************************************}

procedure do_scroll;
begin
  fg_scroll(136,184,50,150,-4,0);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.AppIdle(Sender: Tobject; var Done: Boolean);
begin
  do_scroll;
  Done := False;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb1 := fg_vballoc(VBWIDTH,VBHEIGHT);
  hvb2 := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb2);
  fg_vbcolors;
  fg_vbopen(hvb1);
  fg_vbcolors;
  fg_sethpage(hvb2);

  fg_setcolor(19);
  fg_fillpage;
  fg_setcolor(25);
  fg_rect(132,188,50,150);

  fg_setcolor(20);
  fg_move(160,67);
  fg_draw(175,107);
  fg_draw(140,82);
  fg_draw(180,82);
  fg_draw(145,107);
  fg_draw(160,67);
  fg_paint(160,77);
  fg_paint(150,87);
  fg_paint(160,87);
  fg_paint(170,87);
  fg_paint(155,97);
  fg_paint(165,97);

  Application.OnActivate := AppOnActivate;
  Application.OnIdle := AppIdle;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb1);
  fg_vbfree(hvb2);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
