{*****************************************************************************
*                                                                            *
*  STRING2.DPR                                                               *
*  STRING2U.PAS                                                              *
*                                                                            *
*  This program shows how to display strings in the virtual buffer. Because  *
*  WinG is needed to do this, you must link this program with the Fastgraph  *
*  for Windows WinG support library, and WinG must be available on your      *
*  system.                                                                   *
*                                                                            *
*****************************************************************************}

unit string2U;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWinG;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(24);
  fg_fillpage;

  fg_setcolor(19);
  fg_fontdc(fg_getdc);

  { upper vertical justification }
  fg_move(0,0);
  fg_justify(-1,1);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH div 2,0);
  fg_justify(0,1);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH-1,0);
  fg_justify(1,1);
  fg_print('FG/Windows',10);

  { centered vertical justification }
  fg_move(0,VBHEIGHT div 2);
  fg_justify(-1,0);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH div 2,VBHEIGHT div 2);
  fg_justify(0,0);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH-1,VBHEIGHT div 2);
  fg_justify(1,0);
  fg_print('FG/Windows',10);

  { lower vertical justification }
  fg_move(0,VBHEIGHT-1);
  fg_justify(-1,-1);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH div 2,VBHEIGHT-1);
  fg_justify(0,-1);
  fg_print('FG/Windows',10);
  fg_move(VBWIDTH-1,VBHEIGHT-1);
  fg_justify(1,-1);
  fg_print('FG/Windows',10);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
