{*****************************************************************************
*                                                                            *
*  SWCHARS.DPR                                                               *
*  SWCHARS2.PAS                                                              *
*                                                                            *
*  This program displays all characters in the Fastgraph for Windows primary *
*  and alternate software fonts.                                             *
*                                                                            *
*****************************************************************************}

unit swcharsU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, FGWorld;

type
  TForm1 = class(TForm)
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 640;
  VBHEIGHT = 480;

var
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  xdest, ydest : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_initw;
  fg_setworld(0.0,6.39,0.0,4.79);
  fg_setsizew(0.2);

  fg_setcolor(25);
  fg_fillpage;

  fg_setcolor(19);
  fg_movew(3.2,4.2);
  fg_swchar('Software characters - font 1',28,0);
  fg_setcolor(10);
  fg_movew(0.5,3.9);
  fg_swchar('ABCDEFGHIJKLMNOPQRSTUVWXYZ',26,-1);
  fg_movew(0.5,3.6);
  fg_swchar('abcdefghijklmnopqrstuvwxyz',26,-1);
  fg_movew(0.5,3.3);
  fg_swchar('0123456789',10,-1);
  fg_movew(0.5,3.0);
  fg_swchar('!"#$%&''()*+,-./:;<=>?[]^`{|}~',29,-1);

  fg_setcolor(19);
  fg_movew(3.2,2.5);
  fg_swchar('Software characters - font 2',28,0);
  fg_setcolor(10);
  fg_movew(0.5,2.2);
  fg_swchar('\ABCDEFGHIJKLMNOPRSTUWXYZ',25,-1);
  fg_movew(0.5,1.9);
  fg_swchar('\abcdefghijklmnoprstuwxyz',25,-1);
  fg_movew(0.5,1.3);
  fg_swchar('\012345678#$%&()*+/<=>?[]{}',27,-1);

  fg_setratio(1.2);
  fg_movew(0.5,0.6);
  fg_swchar('cos\^2\h\+sin\^2\h\=1',21,-1);

  fg_movew(5.9,0.6);
  fg_swchar('H\v2O U\v2\v3\v2',16,1);

  fg_setratio(1.0);
  fg_movew(3.2,0.2);
  fg_swchar('One _word_ is underlined.',25,0);

  fg_setcolor(19);
  fg_movew(0.0,2.8);
  fg_draww(6.39,2.8);
  fg_movew(0.0,0.9);
  fg_draww(6.39,0.9);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbpaste(0,VBWIDTH-1,0,VBHEIGHT-1,xdest,ydest);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  xdest := (ClientWidth - VBWIDTH) div 2;
  ydest := (ClientHeight - VBHEIGHT) div 2;
  if (xdest < 0) then xdest := 0;
  if (ydest < 0) then ydest := 0;
  ydest := (ClientHeight-1) - ydest;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

end.
