{*****************************************************************************
*                                                                            *
*  VBDEMO.DPR                                                                *
*  VBDEMOU.PAS                                                               *
*                                                                            *
*  This program demonstrates how to copy the contents of one virtual buffer  *
*  to another, with and without transparent colors.                          *
*                                                                            *
*****************************************************************************}

unit vbdemoU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Cut1: TMenuItem;
    Paste1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Cut(Sender: TObject);
    procedure Paste(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb1, hvb2 : integer;

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb2 := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb2);
  fg_vbcolors;
  hvb1 := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb1);
  fg_vbcolors;

  fg_setcolor(25);
  fg_fillpage;
  fg_setcolor(20);
  fg_rect(VBWIDTH div 4,VBWIDTH*3 div 4,VBHEIGHT div 4,VBHEIGHT*3 div 4);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb1);
  fg_vbfree(hvb2);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.Cut(Sender: TObject);
begin
  fg_vbcopy(0,VBWIDTH-1,0,VBHEIGHT-1,0,VBHEIGHT-1,hvb1,hvb2);
  fg_erase;
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
  Form1.Paste1.Enabled := True;
end;

procedure TForm1.Paste(Sender: TObject);
begin
  fg_tcdefine(25,1);
  fg_vbtccopy(0,VBWIDTH-1,0,VBHEIGHT-1,0,VBHEIGHT-1,hvb2,hvb1);
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
