DEFINT A-N
DIM D(128,64)

CLS
PRINT
PRINT
PRINT
PRINT"                             3-D FRACTAL GENERATOR"
PRINT"                                       BY
PRINT"                                RUSSELL MCINTIRE"
PRINT
PRINT"                       ALGORITHM FROM CREATIVE COMPUTING"
PRINT
FOR I=1 TO 1500: NEXT I

RANDOMIZE
PRINT
INPUT"NUMBER OF LEVELS";LE
DS=2:FOR N=1 TO LE:DS=DS+2^(N-1):NEXT N
MX=DS-1:MY=MX/2:PI=3.1416:RH=PI*30/180:VT=RH*1.2
  FOR N=1 TO LE:L=10000/1.8^N
   PRINT"WORKING ON LEVEL";N
   IB=MX/2^N:SK=IB*2
   GOSUB HEIGHTX
   GOSUB HEIGHTY
   GOSUB HEIGHTD
NEXT N
GOSUB DRAWIT

HEIGHTX:
   FOR YE=0 TO MX-1 STEP SK
      FOR XE=IB+YE TO MX STEP SK
         AX=XE-IB:AY=YE:GOSUB ARRAY:D1=D:AX=XE+IB:GOSUB ARRAY:D2=D
         D=(D1+D2)/2+RND*(L/2)-L/4:AX=XE:AY=YE:GOSUB INARRAY
      NEXT XE
   NEXT YE
RETURN

HEIGHTY:
   FOR XE=MX TO 1 STEP -SK
      FOR YE=IB TO XE STEP SK
         AX=XE:AY=YE+IB:GOSUB ARRAY:D1=D:AY=YE-IB:GOSUB ARRAY:D2=D
         D=(D1+D2)/2+RND*(L/2)-L/4:AX=XE:AY=YE:GOSUB INARRAY
      NEXT YE
   NEXT XE
RETURN

HEIGHTD:
   FOR XE=0 TO MX-1 STEP SK
      FOR YE=IB TO MX-XE STEP SK
         AX=XE+YE-IB:AY=YE-IB:GOSUB ARRAY:D1=D
         AX=XE+YE+IB:AY=YE+IB:GOSUB ARRAY:D2=D
         AX=XE+YE:AY=YE:D=(D1+D2)/2+RND*(L/2)-L/4:GOSUB INARRAY
      NEXT YE
   NEXT XE
RETURN

ARRAY:
   IF AY>MY THEN GOTO A1
      BY=AY:BX=AX:GOTO A2
 A1:
 BY=MX+1-AY:BX=MX-AX
 A2:
 D=D(BX,BY)
RETURN

INARRAY:
   IF AY>MY THEN GOTO I1
   BY=AY:BX=AX:GOTO I2
 I1:
 BY=MX+1-AY:BX=MX-AX
 I2:
 D(BX,BY)=D
RETURN

SEALEV:
   IF XO<>-999 THEN GOTO S1
   IF ZZ<0 THEN GOSUB SEACOL:Z2=ZZ:ZZ=0:GOTO S4
   GOSUB LANDCO :GOTO S3
S1:
   IF (Z2>0 AND ZZ>0) THEN S3
   IF Z2<0 AND ZZ<0 THEN Z2=ZZ:ZZ=0:GOTO S4
   IF ZZ-Z2=0 THEN S2
   W3=ZZ/(ZZ-Z2):X3=(X2-XX)*W3+XX:Y3=(Y2-YY)*W3+YY:Z3=0
S2:
   ZT=ZZ:YT=YY:XT=XX
   IF ZZ>0 THEN GOTO OUTW
INW:
   ZZ=Z3:YY=Y3:XX=X3:GOSUB P1
   GOSUB SEACOL :ZZ=0:YY=YT:XX=XT:Z2=ZT:GOTO S4
OUTW:
   ZZ=Z3:YY=Y3:XX=X3:GOSUB P1
   GOSUB LANDCO:ZZ=ZT:YY=YT:XX=XT
S3:
   Z2=ZZ
S4:
   X2=XX:Y2=YY:RETURN

GOTO P1

LANDCO:
   CN=3
RETURN

SEACOL:
   CN=1
RETURN

SETUP:
   SCREEN 1
RETURN

ROTATE:
   IF XX<>0 THEN R1
   IF YY<=0 THEN RA=-PI/2:GOTO R2
   RA=PI/2:GOTO R2
 R1:
   RA=ATN(YY/XX)
   IF XX<0 THEN RA=RA+PI
 R2:
   R1=RA+RH:RD=SQR(XX*XX+YY*YY)
   XX=RD*COS(R1):YY=RD*SIN(R1)
RETURN

TILT:
   RD=SQR(ZZ*ZZ+XX*XX)
   IF XX=0 THEN RA=PI/2:GOTO T1
   RA=ATN(ZZ/XX)
   IF XX<0 THEN RA=RA+PI
T1:
   R1=RA-VT
   XX=RD*COS(R1)+XX:ZZ=RD*SIN(R1)
RETURN
PLOTIT:
   GOSUB SEALEV
P1:
   XX=XX*XS:YY=YY*YS:ZZ=ZZ*ZS
   GOSUB ROTATE
   GOSUB TILT
   IF XO=-999 THEN PR$="M" ELSE PR$="D"
   XP=INT(YY)+CX:YP=INT(ZZ)
   GOSUB LINEIT
RETURN

LINEIT:
   IF PR$="M" THEN XQQ=XP:YQQ=YP:XO=X
   LINE(XQQ,40-YQQ)-(XP,40-YP),CN
   XQQ=XP:YQQ=YP
RETURN

DRAWIT:
   GOSUB SETUP
   XS=.03:YS=.028:ZS=.03: REM SCALING FACTORS
rept:
   FOR AX=0 TO MX:XO=-999:FOR AY=0 TO AX
   GOSUB ARRAY
   ZZ=D:YY=AY/MX*10000:XX=AX/MX*10000-YY/2
   GOSUB PLOTIT
   NEXT AY:NEXT AX
   FOR AY=0 TO MX:XO=-999:FOR AX=AY TO MX
   GOSUB ARRAY
   ZZ=D:YY=AY/MX*10000:XX=AX/MX*10000-YY/2
   GOSUB PLOTIT
   NEXT AX:NEXT AY
   FOR EX=0 TO MX:XO=-999:FOR EY=0 TO MX-EX
   AX=EX+EY:AY=EY:GOSUB ARRAY:ZZ=D:YY=AY/MX*10000
   XX=AX/MX*10000-YY/2
   GOSUB PLOTIT
   NEXT EY: NEXT EX

LOOPIT:
   C$=INKEY$
   IF C$<>"" THEN  END ELSE GOTO LOOPIT

