program gen3ddrg;

uses CRT,Graph,Fractal;

const
	x_center: integer = 320;
	y_center: integer = 175;
	x: real = 0.50001;
	y: real = 0;
	step_size: real = 0.4;
	upper_limit: real = 3.0;
	lower_limit: real = -3.0;
	file_name: string[14] ='3ddrag00.pcx';

var

	GraphDriver,GraphMode,i,j,row,col,color1,color: integer;
	z,P,Q,k,sx,cx,sy,cy,sz,cz,magnitude,scale,temp,temp_x,temp_y,
		ymax,ymin,alpha,beta,gamma,QVal,x_offset, y_offset: real;
	file_no: string[3];
	ch1: char;

procedure projection(x3: real; y3: real; z3: real);
	var
		temp_x, temp_y: real;
	begin
		temp_x := x3*cx + y3*cy + z3*cz;
		temp_y := x3*sx + y3*sy + z3*sz;
		col := Round(scale * (temp_x-0.5) + x_center + x_offset);
		row := Round(y_center - scale*temp_y + y_offset);
		color := Round(abs(y3*7)) mod 7 + 1;
		if y3>0 then
			color := color + 8;
		if (col>=0) and (col<640) and (row>=0) and (row<350) then
			PutPixel(col,row,color);
	end;

function degrees_to_radians(degrees: real): real;
	const
     	rad_per_degree: real = 0.0174533;

	var
		angle: real;

	begin
		while degrees >= 360 do
			degrees := degrees - 360;
		while degrees < 0 do
			degrees := degrees + 360;
		angle := rad_per_degree*degrees;
		degrees_to_radians := angle;
	end;

begin
	DirectVideo := false;
	ClrScr;
	write('Enter alpha: ');
	Readln(alpha);
	write('Enter beta: ');
	Readln(beta);
	write('Enter gamma: ');
	Readln(gamma);
	write('Enter scale: ');
	Readln(scale);
	scale := x_center * scale;
	write('Enter X offset: ');
	Readln(x_offset);
	write('Enter Y offset: ');
	Readln(y_offset);
	write('Enter Q parameter: ');
	Readln(QVal);
	if QVal = 0 then
	begin
		step_size := 0.1;
		upper_limit := 1.0;
		lower_limit := -1.0;
	end;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	alpha := degrees_to_radians(alpha);
	sx := sin(alpha);
	cx := cos(alpha);
	beta := degrees_to_radians(beta);
	sy := sin(beta);
	cy := cos(beta);
	gamma := degrees_to_radians(gamma);
	sz := sin(gamma);
	cz := cos(gamma);
	color := 1;
	k:= upper_limit;
	while k >= lower_limit do
	begin
		if (k<1.0) and (k>-1.0) then
			step_size := 0.1;
		x := 0.50001;
		y := 0;
		if QVal = 0 then
		begin
			magnitude := 1;
			Q := 4*sqrt(1-k*k);
		end
		else
		begin
			magnitude := k*k + QVal*QVal;
			Q := -4*QVal/magnitude;
		end;
		P := 4*k/magnitude;
		for i:=0 to 12000 do
		begin
			temp_x := x*P - y*Q;
			y := x*Q + y*P;
			temp_y := y;
			x := 1 - temp_x;
			magnitude := sqrt(x*x + y*y);
			y := sqrt((-x + magnitude)/2);
			x := sqrt((x + magnitude) /2);
			if temp_y < 0 then
				x := -x;
			if (random < 0.5) then
			begin
				x := -x;
				y := -y;
			end;
			x := (1 - x)/2;
			y := y/2;
			z :=  P/2;
			if i>10 then
				projection (x, y, z);
		end;
		k := k - step_size;
	end;
	file_no := save_screen(0,0,639,349, file_name);
	ch1 := ReadKey;
end.
