program apollo;

uses CRT,Graph,Fractal;

var
	color,graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	ch: char;
	a,b,c,s,cs,bs,xa,xb,xc,ya,yb,yc,xs,ys,temp: real;

procedure node(xa: real; ya: real; a: real; xb: real; yb: real;
	b: real; xc: real; yc: real; c: real; xs: real; ys: real; s: real;
	level: integer); forward;

procedure gen_circle(xa: real; ya: real; a: real; xb: real; yb: real;
	b: real; xc: real; yc: real; c: real; level: integer);

	var
		s,temp: real;

	begin
		dec(level);
		s := 1/a + 1/b + 1/c + 2*(sqrt(1/(b*c) + 1/(c*a) + 1/(a*b)));
		s := 1/s;
		temp := (s+a)*(s+a) - (s+b)*(s+b) - xa*xa + xb*xb - ya*ya + yb*yb;
		ys := (temp*(xc-xa) - (xb - xa)*((s+a)*(s+a) - (s+c)*(s+c) - xa*xa
		+ xc*xc	- ya*ya + yc*yc))/(2*((yb-ya)*(xc-xa) - (yc-ya)*
		(xb - xa)));
		xs := (temp - 2*ys*(yb - ya))/(2*(xb - xa));
		inc(color);
		SetFillStyle(1,color);
		SetColor(color);
		FillEllipse(Round(xs+320),Round(175-ys*0.7291666),Round(s),Round(s*0.7291666));
		if level > 0 then
			node(xa,ya,a,xb,yb,b,xc,yc,c,xs,ys,s,level);
	end;

procedure node(xa: real; ya: real; a: real; xb: real; yb: real;
	b: real; xc: real; yc: real; c: real; xs: real; ys: real; s: real;
	level: integer);

	begin
		gen_circle(xa,ya,a,xb,yb,b,xs,ys,s,level);
		gen_circle(xb,yb,b,xc,yc,c,xs,ys,s,level);
		gen_circle(xa,ya,a,xc,yc,c,xs,ys,s,level);
	end;

begin

	write('Enter level (1 - 8): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	a := 625;
	b := 375;
	c := 945;
	color := 1;
	xa := -725;
	ya := 235;
	xb := 275;
	yb := 268;
	xc := 180;
	yc := -1048;
	SetFillStyle(1,color);
	setColor(color);
	FillEllipse(Round(xa+320),Round(175-ya*0.7291666),Round(a),Round(a*0.7291666));
	inc(color);
	SetFillStyle(1,color);
	SetColor(color);
	FillEllipse(Round(xb+320),Round(175-yb*0.7291666),Round(b),Round(b*0.7291666));
	inc(color);
	SetFillStyle(1,color);
	SetColor(color);
	FillEllipse(Round(xc+320),Round(175-yc*0.7291666),Round(c),Round(c*0.7291666));
	gen_circle(xa,ya,a,xb,yb,b,xc,yc,c,level);
	ch := ReadKey;
end.
