program bindecom;

uses CRT,Graph,Fractal;

const
	maxrow: integer = 349;
	maxcol: integer = 639;
	max_iterations: integer = 64;
	max_size: real = 4;

var
	GraphDriver,GraphMode,i,j,row,col,color: integer;
	P,Q,deltaX, deltaY, X, Y, Xsquare,Ysquare,Ytemp,temp1,temp2,
	theta,cos_theta,sin_theta: real;
	ch1: char;

begin

	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	XMax := 2.0;
	XMin := -2.0;
	YMax := 1.5;
	YMin := -1.5;
	P := 0;
	Q := 0;
	for j:=0 to 1 do
	begin
		deltaX := (XMax - XMin)/(maxcol);
		deltaY := (YMax - YMin)/(maxrow);
		for col:=0 to maxcol do
		begin
			if KeyPressed then
				exit;
			for row:=0 to maxrow do
			begin
				X := XMin + col * deltaX;
				Y := YMax - row * deltaY;
				Xsquare := 0;
				Ysquare := 0;
				i := 0;
				while (i<max_iterations) and ((Xsquare +
					Ysquare) < max_size) do
				begin
					Xsquare := X*X;
					Ysquare := Y*Y;
					Ytemp := 2*X*Y;
					 X := Xsquare - Ysquare + P;
					 Y := Ytemp + Q;
					 inc(i);
				end;
				if X = 0 then
					color := 15
				else
				begin
					cos_theta := abs(X)/(sqrt(X*X + Y*Y));
					sin_theta := abs(Y)/(sqrt(X*X + Y*Y));
					theta := arctan(sin_theta/cos_theta);
					if (X<0) and (Y>=0) then
						theta := theta + 1.5707963;
					if (X<0) and (Y<0) then
						theta := theta + 3.14159625;
					if (X>0) and (Y<0) then
						theta := theta + 4.7123889;
					if (theta>=0) and (theta<=3.14159625) then
						color := 15
					else
						color := 0;
				end;
				PutPixel(col, row, color);
			end;
		end;
		P := 0.318623;
		Q := 0.0429799;
		ch1 := ReadKey;
		ClearDevice;
	end;
end.
