program brown2d;

uses CRT,Graph,Fractal;

const
	scale: real = 1500;
	h: real = 0.87;
	seed: longint = 3045;
var
	Fh: array[0..2048] of real;
	Fw: array[0..2048] of real;
	ratio,std: real;
	GraphDriver,GraphMode,i: integer;
	ch1: char;

function gauss(seed: longint): real;

var
	value,exponent,gaussian: real;

begin
	if seed <> 0 then
		RandSeed := seed;
	value := (Random - 0.5)*6.0;
	exponent := -(value*value)/2.;
	gaussian := 0.15915494*exp(exponent);
	value := Random;
	if value < 0.5 then
		gauss := - gaussian
	else
		gauss := gaussian;
end;

procedure subdivide (f1: integer; f2: integer; std: real);

	var
		fmid: integer;
		stdmid: real;

	begin
		fmid := (f1 + f2) div 2;
		if (fmid <> f1) and (fmid <> f2) then
		begin
			Fh[fmid] := (Fh[f1] + Fh[f2])/2.0 + gauss(0) * std;
			Fw[fmid] := (Fw[f1] + Fw[f2])/2.0 + gauss(0) * std;
			stdmid := std*ratio;
			subdivide(f1,fmid,stdmid);
			subdivide(fmid,f2,stdmid);
		end;
	end;

begin

	while seed <> 0 do
	begin
		CloseGraph;
		write('Enter seed (0 to quit): ');
		Readln(seed);
		GraphDriver := 4;
		GraphMode := EGAHi;
		InitGraph(graphDriver,GraphMode,'');
		SetLineStyle(0,$FFFF,1);
		SetColor(15);
		Fh[0] := gauss(seed) * scale;
		Fh[2048] := gauss(0) * scale;
		Fw[0] := gauss(seed) * scale;
		Fw[2048] := gauss(0) * scale;
		ratio := Exp(-0.693147*h);
		std := scale*ratio;
		subdivide(0,2048,std);
		for i:=0 to 2047 do
			Line(Round(Fw[i])+320,175-Round(Fh[i]),Round(Fw[i+1])+320,
				175-Round(Fh[i+1]));
		SetLineStyle(3,$0F0F,1);
		Line(80,175,590,175);
		Line(320,0,320,349);
		SetLineStyle(0,$FFFF,1);
		ch1 := ReadKey;
	end;
end.
