program brownian;

uses CRT,Graph,Fractal;

const
	scale: real = 80;
	h: real = 0.87;
	seed: longint = 3456;
        mu: real = 0.0;
        sigma: real = 1.0;

var
	Fh: array[0..256] of real;
	ratio,std: real;
	GraphDriver,GraphMode,i: integer;
	ch1: char;

function gauss(seed: longint; mu: real; sigma: real): real;

var
	x,sum: real;
        i: integer;

begin
	if seed <> 0 then
		RandSeed := seed;
	x := 0;
        for i:= 0 to 11 do
            x := x + Random;
        x := x - 6.0;
        gauss := mu + sigma * x;
end;

procedure subdivide (f1: integer; f2: integer; std: real);

	var
		fmid: integer;
		stdmid: real;

	begin
		fmid := (f1 + f2) div 2;
		if (fmid <> f1) and (fmid <> f2) then
		begin
			Fh[fmid] := (Fh[f1] + Fh[f2])/2.0 +
                                 gauss(0,mu,sigma) * std;
			stdmid := std*ratio;
			subdivide(f1,fmid,stdmid);
			subdivide(fmid,f2,stdmid);
		end;
	end;

begin

	while seed <> 0 do
	begin
		CloseGraph;
		write('Enter seed (0 to quit): ');
		Readln(seed);
		GraphDriver := 4;
		GraphMode := EGAHi;
		InitGraph(graphDriver,GraphMode,'');
		SetLineStyle(0,$FFFF,1);
		SetColor(15);
		Fh[0] := gauss(seed,mu,sigma) * scale;
		Fh[256] := gauss(0,mu,sigma) * scale;
		ratio := Exp(-0.693147*h);
		std := scale*ratio;
		subdivide(0,256,std);
		for i:=0 to 255 do
			Line(2*i+80,175-Round(Fh[i]),2*(i+1)+80,175-Round(Fh[i+1]));
		SetLineStyle(3,$0F0F,1);
			Line(80,175,590,175);
		SetLineStyle(0,$FFFF,1);
		ch1 := ReadKey;
	end;
end.
