program cesaromd;

uses CRT,Graph,Fractal;

var
	sign1,graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	Xpoints, Ypoints: array[0..24] of real;
	initiator_x1,initiator_x2,initiator_y1,initiator_y2: array[0..9]
		of real;
	ch: char;
	sign: array[0..15] of integer;

procedure generate (X1: real; Y1: real; X2: real; Y2: real;
	level: integer);
	var
		j,k: integer;
		a, b: real;
		Xpoints, Ypoints: array[0..24] of real;

	begin

		dec(level);
		a := sqrt((X2 - X1)*(X2 - X1) + (Y2 - Y1)*(Y2 - Y1))/2.0;
		b := a * 0.9128442;
		turtle_r := b;
		Xpoints[0] := X1;
		Ypoints[0] := Y1;
		Xpoints[2] := X2;
		Ypoints[2] := Y2;
		turtle_theta := point(X1,Y1,X2,Y2);
		turtle_x := X1;
		turtle_y := Y1;
		step;
		Xpoints[3] := turtle_x;
		Ypoints[3] := turtle_y;
		turn(85*sign[level]);
		turtle_r := a;
		step;
		Xpoints[1] := turtle_x;
		Ypoints[1] := turtle_y;
		turn(-170*sign[level]);
		step;
		Xpoints[4] := turtle_x;
		Ypoints[4] := turtle_y;
		if level > 0 then
		begin
			for j:=0 to generator_size - 2 do
			begin
				X1 := Xpoints[j];
          		X2 := Xpoints[j+1];
          		Y1 := Ypoints[j];
          		Y2 := Ypoints[j+1];
				generate (X1,Y1,X2,Y2,level);
			end;
		end
		else
		begin
			Line(Round(Xpoints[0]+320),Round(175 - Ypoints[0]*0.729)
				,Round(Xpoints[3]+320),Round(175 - Ypoints[3]*
				0.729));
			Line(Round(Xpoints[2]+320),Round(175 - Ypoints[2]*0.729)
				,Round(Xpoints[4]+320),Round(175 - Ypoints[4]*
				0.729));
			Line(Round(Xpoints[3]+320),Round(175 - Ypoints[3]*0.729)
				,Round(Xpoints[1]+320),Round(175 - Ypoints[1]*
				0.729));
			Line(Round(Xpoints[4]+320),Round(175 - Ypoints[4]*0.729)
				,Round(Xpoints[1]+320),Round(175 - Ypoints[1]*
				0.729));
		end;
	end;

begin

	generator_size := 3;
	init_size := 1;
	initiator_x1[0] := -150;
	initiator_x2[0] := 150;
	initiator_y1[0] := 0;
	initiator_y2[0] := 0;
	write('Enter level (1 - 16): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	sign1 := -1;
	for i:=level downto 0  do
	begin
		sign[i] := sign1;
		sign1 := -sign1;
	end;
	for i:=0 to init_size - 1 do
	begin
		generate(initiator_x1[i], initiator_y1[i], initiator_x2[i],
			initiator_y2[i], level);
	end;
	ch := ReadKey;
end.
