program csdragon;

uses CRT,Graph,Fractal;

const
	maxcol: integer = 639;
	maxrow: integer = 349;
	max_size: real = 4;
	file_string: array[0..1] of string[7] = (('drgset'),('dstpal'));
	file2: string[5] = '.pcx';
	file3: string[5] = '.pal';
	rect: array[1..4] of PointType = ((x: 0; y: 0),
							    (x: 639; y: 0),
							    (x: 639; y: 349),
							    (x: 0; y: 349));

var
	graphDriver,GraphMode,i,j,key,generator_size,level,init_size,
		file_no,color,row,col,error,start_col,end_mask,
		m,color_option,max_iterations: integer;
	xtemp,ytemp,deltaP,deltaQ,X,Y,Xsquare,Ysquare,P: real;
	ch1: char;
	colors: array[0..14,0..2] of integer;
	file1: string[3];
	file_name,file_name2: string[12];
	f: file of byte;
	f_pal: file of integer;
	Q: array[0..349] of real;

function menu(types: integer): integer;

const
	TextData: array[0..3] of string[45] =
		(('Generate the Mandelbrot-like Set for Dragons'),
		('Expand a Section of an Existing Dragon Set'),
		('Complete an Unfinished Dragon Set'),
		('Quit'));
	TextData2: array[0..1] of string[45] =
		(('Select colors and ranges'),
		('Cycle through colors in order'));

var
	i,k: integer;
	ch1: char;
begin
	k := 0;
	Window(1,1,80,25);
	TextBackground(0);
	clrscr;
	if types = 0 then
	begin
		Window(10,6,59,13);
		m := 3;
	end
	else
	begin
		Window(10,6,59,11);
		m := 1;
	end;
	TextBackground(1);
	clrscr;
	GotoXY(3,2);
	TextColor(10);
	write('Make your choice with the up and down arrows:');
	repeat
		for i:=0 to m do
		begin
			if i = k then
			begin
				TextColor(1);
				TextBackground(15);
			end
			else
			begin
				TextColor(15);
				TextBackground(1);
			end;
			GotoXY(3,i+4);
			if types = 0 then
				write(TextData[i])
			else
				write(TextData2[i]);
		end;
		ch1:= ReadKey;
		if ch1 = char($00) then
		begin
			ch1 := ReadKey;
			case ch1 of
				 'P': begin
						if k = 3 then
							k := 0
						else
							inc(k);
					 end;
				 'H': begin
						if k = 0 then
							k := 3
						else
							dec(k);
					 end;
			end;
		end;
	until ch1 = char($0D);
	window(1,1,80,25);
	menu := k;
end;

function set_colors: integer;

const
	color_set: array[0..1] of integer = (1,1);

var
	i,k: integer;
	ch1: char;
begin
	TextBackground(4);
	clrscr;
     	k := 0;
	Window(10,4,70,22);
	TextBackground(0);
	clrscr;
	GotoXY(3,1);
	TextColor(10);
	writeln('Enter Upper Limit Number and use Arrows to Set Colors:');
	writeln;
	TextColor(14);
	write('  Start Iters   End Iters   Color #1  Color #2');
	writeln;
	i := 0;
	colors[0,0] := 0;
	colors[1,0] := 0;
	while colors[i,0] < max_iterations do
	begin
		inc(i);
		TextColor(15);
		GotoXY(6,i+5);
		write(colors[i-1,0]);
		GotoXY(20,i+5);
		Read(colors[i,0]);
		if colors[i,0] <= colors[i-1,0] then
		begin
			colors[i,0] := colors[i-1,0] + 1;
			GotoXY(20,i+5);
			write(colors[i,0]);
		end;
		if (i = 13) or (colors[i,0] > max_iterations)
		then
		begin
			colors[i,0] := max_iterations;
			GotoXY(20,i+5);
			write(colors[i,0]);
		end;
		GotoXY(30,i+5);
		TextColor(color_set[0]);
		write(char($DB),char($DB),char($DB),char($DB),char($DB),char($DB));
		TextColor(color_set[1]);
		GotoXY(40,i+5);
		write(char($DB),char($DB),char($DB),char($DB),char($DB),char($DB));
		for k:= 0 to 1 do
		begin
			GotoXY(36+ 10*k,i+5);
			repeat
				ch1:= ReadKey;
				if ch1 = char($00) then
				begin
					ch1 := ReadKey;
					case ch1 of
						 'P': begin
							if color_set[k] = 15 then
								color_set[k] := 0
							else
								inc(color_set[k]);
							 end;
						 'H': begin
								if color_set[k] = 0 then
									color_set[k] := 15
								else
									dec(color_set[k]);
							 end;
					end;
				end;
				GotoXY(30+10*k,i+5);
				TextColor(color_set[k]);
				write(char($DB),char($DB),char($DB),char($DB),char($DB),
					char($DB));
			until ch1 = char($0D);
		end;
		colors[i,1] := color_set[0];
		colors[i,2] := color_set[1];
		set_colors := i;
	end;
	Window(1,1,80,25);
	clrscr;
	TextColor(15);
end;

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	repeat
		key := menu(0);
		if key = 3 then
			exit;
		if key < 2 then
		begin
			TextBackground(0);
			clrscr;
			Window(15,8,66,11);
			TextBackground(4);
			clrscr;
			GotoXY(3,2);
			TextColor(15);
			write('Enter number of iterations desired (16-512): ');
			readln(max_iterations);
			if max_iterations < 16 then
				max_iterations := 16;
			if max_iterations > 512 then
				max_iterations := 512;
		end;
		color_option := menu(1);
		if (key < 2) and (color_option = 0) then
			end_mask :=  set_colors;
		TextBackground(0);
		clrscr;
		Window(15,8,66,11);
		TextBackground(2);
		clrscr;
		GotoXY(3,2);
		TextColor(15);
		if key <> 0 then
		begin
			write('Enter "DRGSET" file number (00 - 99): ');
			readln(file_no);
			Str(file_no,file1);
			Window(1,1,80,25);
			if file_no < 10 then
				file_name := Concat(file_string[0],'0',file1,file2)
			else
				file_name := Concat(file_string[0],file1,file2);
			error := restore_screen(file_name);
			if error = 0 then
				exit
		end;
		CURSOR_X := 0;
		CURSOR_Y := 0;
		case key of
		0: begin
			start_col := 0;
			XMax := 4.2;
			XMin := -2.2;
			YMax := 1.5;
			YMin := -1.5;
			file_name := Concat(file_string[0],'00',file2);
			InitGraph(GraphDriver,GraphMode,'');
			SetFillStyle(1,7);
			FillPoly(4,rect);
		   end;
		2: begin

			if (error = 639) or (error = 0) then
				exit;
			start_col := 8 * (error div 8);
			Assign(f,file_name);
			Erase(f);
			if color_option = 0 then
			begin
				file_name2 := ConCat(file_string[1],file1,file3);
				Assign(f_pal,file_name2);
				Reset(f_pal);
				for i:= 0 to 14 do
					for j:= 0 to 2 do
						read(f_pal,colors[i,j]);
				read(f_pal,max_iterations);
				read(f_pal,end_mask);
				Close(f_pal);
			end;
		   end;
			1: begin
				move_cursor(0,15,0,0);
				move_cursor(1,15,CURSOR_X,CURSOR_Y);
				XMax := TXMax;
				XMin := TXMin;
				YMax := TYMax;
				YMin := TYMin;
				start_col := 0;
				SetFillStyle(1,7);
				FillPoly(4,rect);
			   end;
			end;
		deltaP := (XMax - XMin)/(maxcol);
		deltaQ := (YMax - YMin)/(maxrow);
		Q[0] := YMax;
		for row:=1 to maxrow do
			Q[row] := Q[row-1] - deltaQ;
			P := XMin + start_col * deltaP;
		for col:=start_col to maxcol do
		begin
			if KeyPressed then
			begin
				file1 := save_screen(0,0,col,349,file_name);
				gotoxy(1,24);
				file_name := ConCat(file_string[0],file1,file2);
				write('File name is: ',file_name);
				if color_option = 0 then
				begin
					file_name := ConCat(file_string[1],file1,file3);
					Assign(f_pal,file_name);
					Rewrite(f_pal);
					for i:= 0 to 14 do
						for j:= 0 to 2 do
							write(f_pal,colors[i,j]);
					write(f_pal,max_iterations);
					write(f_pal,end_mask);
					Close(f_pal);
				end;
				exit;
			end;
			for row:=0 to maxrow do
			begin
				X := 0.50;
				Y := 0.0;
				color := 0;
				Xsquare := 0;
				Ysquare := 0;
				color := 1;
				while (color<max_iterations) and
					((X*X + Y*Y) < max_size) do
				begin
					Xtemp := (Y - X)*(Y + X) + X;
					Ytemp := X * Y;
					Ytemp := Ytemp + Ytemp - Y;
					X := P * Xtemp + Q[row] * Ytemp;
					Y := Q[row] * Xtemp - P * Ytemp;
					inc(color);
				end;
				if color_option = 0 then
				begin
					i := 0;
					while (color > colors[i,0]) do
						inc(i);
					if color mod 2= 0 then
						PutPixel(col,row,colors[i][2])
					else
						PutPixel(col,row,colors[i][1]);
				end
				else
					PutPixel(col,row,color mod 16);
			end;
			P := P + deltaP;
		end;
		file1 := save_screen(0,0,639,349,file_name);
		gotoxy(1,24);
		file_name := ConCat(file_string[0],file1,file2);
		write('File name is: ',file_name);
		ch1 := ReadKey;
		CloseGraph;
	until key = 3;
end.
