program dragout;

uses CRT,Graph,Fractal;

const
	x: real = 0.50001;
	y: real = 0;
	x_center: integer = 320;
	y_center: integer = 175;
var
	col,row,graphDriver,GraphMode,i: integer;
	P,Q,magnitude,scale,temp,temp_x,temp_y: real;
	ch1: char;

begin
	write('Enter P and Q (real and imaginary parameters) separated by',
		' a space): ');
	Readln(P,Q);
	magnitude := P*P + Q*Q;
	P := 4*P/magnitude;
	Q := -4*Q/magnitude;
	write('Enter Scale: ');
	Readln(scale);
	scale := x_center*scale;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	for i:=0 to 12000 do
	begin
		temp_x := x*P - y*Q;
		y := x*Q + y*P;
		temp_y := y;
		x := 1 - temp_x;
		magnitude := sqrt(x*x + y*y);
		y := sqrt((-x + magnitude)/2);
		x := sqrt((x + magnitude) /2);
		if temp_y < 0 then
			x := -x;
		if random < 0.5 then
		begin
			x := -x;
			y := -y;
		end;
		x := (1 - x)/2;
		y := y/2;
		col := Round(scale*(x-0.5) + x_center);
		row := Round(y_center - scale*y);
		if (i > 10) and (col >= 0) and (col < 640) and (row >= 0) and
			(row < 350) then
			PutPixel(col,row,15);
	end;
	ch1 := ReadKey;
end.
