program forest;

uses CRT, Graph,Fractal;

const
	color_set: array[0..15] of integer =(43,33,2,34,16,35,20,48,48,45,58,
		2,6,27,62,63);
	ln_2: real = (0.6931471);
	Square: array[1..4] of PointType =   ((x: 50;   y: 100),
								   (x: 100;  y: 100),
								   (x: 100;  y: 100),
								   (x: 150;  y: 150));
	file_name: array[0..11] of char = 'forest00.pcx';

var

	GraphDriver,GraphMode,i,j,level,width,indx,jndx: integer;
	Triangle: array[1..3] of PointType;
	height,left_alpha,right_alpha,left_angle,right_angle,
	left_width_factor,left_height_factor,right_width_factor,
	right_height_factor,x,y,x1,y1,x2,y2,val1,val2: real;
	list: array[0..20,0..1] of real;
	y_max,xz,yz,xp,yp: real;
	file_no: string[3];
	ch: char;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer); forward;


procedure midpoint(x: real; y: real);

var
	r,w: real;
	seed: longint;

begin
	seed := Round(350*y + x);
	RandSeed := seed;
	r := 0.33333 + Random/3.0;
	w := 0.015 + Random/50.0;
	if Random < 0.5 then
		w := -w;
	xz := r*x - (w+0.05)*y;
	yz := r*y + (w +0.05)*x;
end;

procedure node(x1: integer; y1: integer; x2: integer; y2:integer;
	x3: integer; y3: integer; x4: integer; y4: integer; x5: integer;
	y5: integer; x6: integer; y6: integer; level: integer;
	color1: integer; color2: integer);

var
	x_ret1, y_ret1, x_ret2, y_ret2, x_ret3, y_ret3: integer;

begin
	if level <> 0 then
	begin
		generate (x1,y1,x6,y6,x4,y4,level-1,color1,color2);
		generate (x2,y2,x4,y4,x5,y5,level-1,color1,color2);
		generate (x3,y3,x5,y5,x6,y6,level-1,color1,color2);
		generate (x4,y4,x5,y5,x6,y6,level-1,color1,color2);
	end;
end;

procedure plot_triangle(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; color1: integer; color2: integer);

var
	color,temp: integer;
	zt,ytt: real;

begin
	if y1 > y2 then
		ytt := y1
	else
		ytt := y2;
	if ytt < y3 then
		ytt := y3;
	zt := 1 - ((ytt+240)*(ytt+240))/((y_max+240)*(y_max+240));
	if Random <= zt then
		color := color1
	else
		color := color2;
	if ytt + 240 <  ((y_max + 240)/4) then
		color := color1;
	if ytt+240 > (0.98 * (y_max+240)) then
		color := color2;
	Triangle[1].x := x1 + 320;
	Triangle[1].y := 175 - (longint(93*y1) div 128);
	Triangle[2].x := x2 + 320;
	Triangle[2].y := 175 - (longint(93*y2) div 128);
	Triangle[3].x := x3 + 320;
	Triangle[3].y := 175 - (longint(93*y3) div 128);
	SetColor(color);
	SetFillStyle(1,color);
	FillPoly(3,Triangle);
end;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer);

var
	x4,x5,x6,y4,y5,y6: integer;

begin

	x := x2 - x1;
	y := y2 - y1;
	midpoint(x,y);
	x4 := x1 + Round(xz);
	y4 := y1 + Round(yz);
	x := x1 - x3;
	y := y1 - y3;
	midpoint(x,y);
	x6 := x3 + Round(xz);
	y6 := y3 + Round(yz);
	x := x3 - x2;
	y := y3 - y2;
	midpoint(x,y);
	x5 := x2 + Round(xz);
	y5 := y2 + Round(yz);
	if level = 0 then
	begin
		plot_triangle(x1,y1,x6,y6,x4,y4,color1,color2);
		plot_triangle(x2,y2,x4,y4,x5,y5,color1,color2);
		plot_triangle(x3,y3,x5,y5,x6,y6,color1,color2);
		plot_triangle(x4,y4,x5,y5,x6,y6,color1,color2);
	end
	else
		node(x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,color1,
				color2);
end;
procedure t_generate(x: real; y: real; width: integer; height: real; angle: real;
	level: integer);

var
	x1,y1: real;

	begin
		turtle_x := x;
		turtle_y := y;
		turtle_r := height;
		step;
		x1 := turtle_x;
		y1 := turtle_y;
		dec(level);
		if level < 3 then
		begin
			SetColor(10);
			SetFillStyle(1,10);
		end
		else
		begin
			SetColor(6);
			SetFillStyle(1,6);
		end;
		if Abs(x - x1) > Abs(y - y1) then
		begin
			Square[1].x := Round(x+320);
			Square[1].y := Round(175 - y*0.729) + width div 2;
			Square[2].x := Round(x+320);
			Square[2].y := Round(175 - y*0.729) - width div 2;
			Square[3].x := Round(x1+320);
			Square[3].y := Round(175 - y1*0.729) - width div 2;
			Square[4].x := Round(x1+320);
			Square[4].y := Round(175 - y1*0.729) + width div 2;
		end
		else
		begin
			Square[1].x := Round(x+320) - width div 2;
			Square[1].y := Round(175 - y*0.729);
			Square[2].x := Round(x+320) + width div 2;
			Square[2].y := Round(175 - y*0.729);
			Square[3].x := Round(x1+320) + width div 2;
			Square[3].y := Round(175 - y1*0.729);
			Square[4].x := Round(x1+320) - width div 2;
			Square[4].y := Round(175 - y1*0.729);
		end;
		FillPoly(4,Square);
		if level > 0 then
		begin
			turtle_theta := point(x,y,x1,y1);
			turn(left_angle);
			t_generate(x1,y1,Round(left_width_factor*width),left_height_factor*
				height,left_angle,level);
			turtle_theta := point(x,y,x1,y1);
			turn(-right_angle);
			t_generate(x1,y1,Round(right_width_factor*width),right_height_factor*
				height,right_angle,level);
		end;
	end;

procedure trees(x: real; y: real);

	begin
		height := Round((240 - y)/12);
		width := Round((240 - y)/48);
		left_alpha := 1.3 + Random;
		right_alpha := 1.3 + Random;
		left_angle := 20.0 + 5*Random;
		right_angle := 20.0 + 5*Random;
		level := 14;
		left_width_factor := exp((-1/left_alpha)*ln_2);
		left_height_factor := exp((-2/(3*left_alpha))*ln_2);
		right_width_factor := exp((-1/right_alpha)*ln_2);
		right_height_factor := exp((-2/(3*right_alpha))*ln_2);
		x1 := x;
		y1 := y + height;
		SetColor(6);
		SetFillStyle(1,6);
		if Abs(x - x1) > Abs(y - y1) then
		begin
			Square[1].x := Round(x+320);
			Square[1].y := Round(175 - y*0.729) + width div 2;
			Square[2].x := Round(x+320);
			Square[2].y := Round(175 - y*0.729) - width div 2;
			Square[3].x := Round(x1+320);
			Square[3].y := Round(175 - y1*0.729) - width div 2;
			Square[4].x := Round(x1+320);
			Square[4].y := Round(175 - y1*0.729) + width div 2;
		end
		else
		begin
			Square[1].x := Round(x+320) - width div 2;
			Square[1].y := Round(175 - y*0.729);
			Square[2].x := Round(x+320) + width div 2;
			Square[2].y := Round(175 - y*0.729);
			Square[3].x := Round(x1+320) + width div 2;
			Square[3].y := Round(175 - y1*0.729);
			Square[4].x := Round(x1+320) - width div 2;
			Square[4].y := Round(175 - y1*0.729);
		end;
		FillPoly(4,Square);
		turtle_theta := point(x,y,x1,y1);
		turn(left_angle);
		t_generate(x1,y1,Round(left_width_factor*width),
			left_height_factor*height,left_angle,level);
		turtle_theta := point(x,y,x1,y1);
		turn(-right_angle);
		t_generate(x1,y1,Round(right_width_factor*width),
			right_height_factor*height,right_angle,level);
	end;

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetBkColor(9);
	ClearDevice;
	for i:=0 to 15 do
		setEGApalette(i,color_set[i]);
	y_max := 180;
	generate(-220,-240,220,125,500,-40,6,1,3);
	y_max := 160;
	generate(-880,-200,30,125,680,-150,6,4,5);
	y_max := 180;
	generate(-580,0,-240,100,150,-60,5,7,10);
	generate(-300,-260,200,40,500,-180,5,8,11);
	Square[1].x := 0;
	Square[1].y := 180;
	Square[2].x := 639;
	Square[2].y := 180;
	Square[3].x := 639;
	Square[3].y := 349;
	Square[4].x := 0;
	Square[4].y := 349;
	SetColor(2);
	SetFillStyle(1,2);
	FillPoly(4,Square);
        for i:= 0 to 20 do
	begin
		list[i,0] := 639*Random - 320;
                list[i,1] := 230*Random - 240;
	end;
	for indx:=0 to 19 do
	begin
             for jndx:=indx to 20 do
             begin
                  if list[jndx,1] < list[indx,1] then
                  begin
                       val1 := list[jndx,0];
                       val2 := list[jndx,1];
                       list[jndx,0] := list[indx,0];
                       list[jndx,1] := list[indx,1];
                       list[indx,0] := val1;
                       list[indx,1] := val2;
                  end;
             end;
	end;
	for i:=20 downto 0 do
	begin
		x := list[i,0];
		y := list[i,1];
		trees(x,y);
	end;
	file_no := save_screen(0,0,639,350,file_name);
	ch := ReadKey;
end.

