unit Fractal;

interface

const

	PALETTE: array[0..15] of byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,
		62,63);

var

	turtle_r,turtle_x,turtle_y,turtle_theta,XMax,XMin,YMax,YMin,TXMax,
		TXMin,TYMax,TYMin,Pval,Qval: real;
	CURSOR_X,CURSOR_Y: integer;

procedure setEGApalette(pal:integer; color:integer);
function read_screen(address: longint; color_plane: integer):byte;
procedure display(address: longint; color_plane: integer; ch: byte);
function point(x1: real; y_one: real; x2: real; y2: real): real;
procedure step;
procedure turn(angle: real);
function save_screen(x1: integer; y1: integer; x2: integer; y2:integer;
	file_name: string): string;
function restore_screen(file_name:string):integer;
procedure move_cursor(C_type: integer; color: integer; min_col: integer;
	min_row: integer);

implementation
uses CRT,Graph,Dos;


procedure setEGApalette(pal:integer; color:integer);

	var
		regs: Registers;

	begin


		with regs do
		begin
			PALETTE[pal] := byte(color);
			AH := $10;
			AL := 0;
			BH := color;
			BL := pal;
			intr($10,regs);
		end;
	end;


function read_screen(address: longint; color_plane: integer):byte;

var
	pixel_data: byte;

begin
	Port[$3CE] := 4;
	Port[$3CF] := color_plane;
	Port[$3CE] := 5;
	Port[$3CF] := 0;
	pixel_data := byte(Mem[$A000:address]);
	read_screen := pixel_data;
end;

procedure display(address: longint; color_plane: integer; ch: byte);

	var
		dummy: byte;
		k: byte;
		m: char;
	begin
		dummy := Mem[$A000:address];
		Port[$3C4] := 2;
		Port[$3C5] := $01 shl color_plane;
		Mem[$A000:address] := ch;
	end;


function point(x1: real; y_one: real; x2: real; y2: real): real;
	var
		theta: real;
	begin
		if (x2 - x1) = 0 then
			if y2 > y_one then
				theta := 90
			else
				theta := 270
		else
			theta := arctan((y2-y_one)/(x2-x1))*57.295779;
		if x1>x2 then
			theta := theta + 180;
		point := theta;
	end;


procedure step;

	begin
		turtle_x := turtle_x + turtle_r*cos(turtle_theta*0.017453292);
		turtle_y := turtle_y + turtle_r*sin(turtle_theta*0.017453292);
	end;


procedure turn(angle: real);

	begin
		turtle_theta := turtle_theta + angle;
	end;

function save_screen(x1: integer; y1: integer; x2: integer; y2:integer;
	file_name: string):string;


	type
		intRec = record
					lo,hi: byte;
				end;
		floatRec = record
					first,second,third,fourth: byte;
				end;
	var
		FileExists: boolean;
		B: byte;
		GraphDriver, GraphMode,i,j,k,add1,add2,number,
			line_length, ending, start_line, end_line: integer;
		ch,ch1,old_ch,num_out,red,green,blue,color: byte;
		fsave: FILE OF byte;
		floating: single;
                file_no: string[3];

	begin
		sound (256);
		repeat
			{$I-}
			Assign(fsave,file_name);
			Reset(fsave);
			Close(fsave);
			{$I+}
			FileExists := (IOResult = 0);
			if FileExists then
			begin
				inc(file_name[8]);
				if file_name[8] >= char($3A) then
				begin
					file_name[8] := char($30);
					inc(file_name[7]);
				end;
			end;
		until not FileExists or (file_name[7] > char($39));
		Assign(fsave,file_name);
                file_no := Copy(file_name,7,2);
		Rewrite(fsave);
		ch := $0A;
		Write(fsave,ch);
		ch := $05;
		Write(fsave,ch);
		ch := $01;
		Write(fsave,ch);
		ch := $04;
		Write(fsave,ch);
		B := intRec(x1).lo;
		Write(fsave,B);
		B := intRec(x1).hi;
		Write(fsave,B);
		B := intRec(y1).lo;
		Write(fsave,B);
		B := intRec(y1).hi;
		Write(fsave,B);
		B := intRec(x2).lo;
		Write(fsave,B);
		B := intRec(x2).hi;
		Write(fsave,B);
		B := intRec(y2).lo;
		Write(fsave,B);
		B := intRec(y2).hi;
		Write(fsave,B);
		number := 640;
		B := intRec(number).lo;
		Write(fsave,B);
		B := intRec(number).hi;
		Write(fsave,B);
		number := 350;
		B := intRec(number).lo;
		Write(fsave,B);
		B := intRec(number).hi;
		Write(fsave,B);
		ch := 0;
		for i:=0 to 15 do
		begin
			red := (((PALETTE[i] and $20) shr 5) or
				((PALETTE[i] and $04) shr 1)) * 85;
			green := (((PALETTE[i] and $10) shr 4) or
				(PALETTE[i] and $02)) * 85;
			blue := (((PALETTE[i] and $08) shr 3) or
				((PALETTE[i] and $01) shl 1)) * 85;
			Write(fsave,red);
			Write(fsave,green);
			Write(fsave,blue);
		end;
		ch := $00;
		Write(fsave,ch);
		ch := $04;
		Write(fsave,ch);
		start_line := x1 div 8;
		end_line := x2 div 8 + 1;
		line_length := end_line - start_line;
		ending := start_line + line_length * 4 + 1;
		B := intRec(line_length).lo;
		Write(fsave,B);
		B := intRec(line_length).hi;
		Write(fsave,B);
		number := 1;
		B := intRec(number).lo;
		Write(fsave,B);
		B := intRec(number).hi;
		Write(fsave,B);
		floating := XMax;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		floating := XMin;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		floating := YMax;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		floating := YMin;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		floating := Pval;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		floating := Qval;
		B := floatRec(floating).first;
		Write(fsave,B);
		B := floatRec(floating).second;
		Write(fsave,B);
		B := floatRec(floating).third;
		Write(fsave,B);
		B := floatRec(floating).fourth;
		Write(fsave,B);
		ch := byte(' ');
		for i:=94 to 127 do
			Write(fsave,ch);
		for k:=y1 to y2 - 1 do
		begin
			add1 := 80*k;
			number := 1;
			j := 0;
			add2 := (start_line);
			old_ch := read_screen(add1 + add2,0);
			inc(add2);
			for i:=add2 to ending-1 do
			begin
				if i = ending - 1 then
				   if old_ch = 0 then
                                   	ch := 1
                                   else
                                       ch := 0
				else
				begin
					if add2 = end_line then
					begin
						inc(j);
						add2 := (start_line);
					end;
					ch := read_screen(add1 + add2,j);
				end;
				if ((ch = old_ch) and (number < 63)) then
					inc(number)
				else
				begin
					num_out := byte(number or $C0);
					if ((number <> 1) or ((old_ch and $C0) = $C0))
						then
					Write(fsave, num_out);
					Write(fsave,old_ch);
					old_ch := ch;
					number := 1;
				end;
				inc(add2);
			end;
		end;
		Close(fsave);
		nosound;
                save_screen := file_no;
	end;


function restore_screen(file_name:string):integer;

	type
		buffer = array[0..3] of byte;
		buffer2 = array[0..1] of byte;
	var
		bufptr: ^buffer;
		bufptr2: ^buffer2;
		ch,ch1,red,green,blue,color: byte;
		line_length,l_end: char;
		GraphDriver,GraphMode,line_end,i,j,k,m,pass,x1,y1,x2,y2: integer;
		fsave: FILE OF byte;
	begin
		New(bufptr);
		New(bufptr2);
		{$I-}
		Assign(fsave,file_name);
		Reset(fsave);
		{$I+}
		if IOResult <> 0 then
		begin
			writeln('Can''t find ',file_name);
			Exit;
		end;
		Read(fsave,ch);
		if ch <> $0A then
		begin
			writeln(file_name,' is not a valid ZSoft file.');
			Close(fsave);
			Exit;
		end;
		for i:= 1 to 3 do
			Read(fsave,ch);
		for i:=0 to 1 do
			Read(fsave,bufptr2^[i]);
		x1 := integer(bufptr2^);
		for i:=0 to 1 do
			Read(fsave,bufptr2^[i]);
		y1 := integer(bufptr2^);
		for i:=0 to 1 do
			Read(fsave,bufptr2^[i]);
		x2 := integer(bufptr2^);
		for i:=0 to 1 do
			Read(fsave,bufptr2^[i]);
		y2 := integer(bufptr2^);
		for i:=12 to 15 do
			Read(fsave,ch);
		GraphDriver := 4;
		GraphMode := EGAHi;
		InitGraph(GraphDriver,GraphMode,'');
		for i:=0 to 15 do
		begin
			Read(fsave,ch);
			red := ch div 85;
			Read(fsave,ch);
			green := ch div 85;
			Read(fsave,ch);
			blue := ch div 85;
			color := ((red and $01) shl 5) or ((red and $02)
				shl 1) or ((green and $01) shl 4) or (green
				and $02) or ((blue and $01) shl 3) or ((blue and
				$02) shr 1);
			setEGApalette(i,color);
		end;
		for i:=64 to 69 do
			Read(fsave,ch);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		XMax := single(bufptr^);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		XMin := single(bufptr^);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		YMax := single(bufptr^);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		YMin := single(bufptr^);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		Pval := single(bufptr^);
		for i:=0 to 3 do
			Read(fsave,bufptr^[i]);
		Qval := single(bufptr^);
		for i:= 94 to 127 do
			Read(fsave,ch);
		Port[$3CE] := 8;
		Port[$3CF] := $FF;
		Port[$3CE] := 3;
		Port[$3CF] := $10;
		for k:=y1 to y2-1 do
		begin
			i := k*80 + (x1 div 8);
			line_end := k* 80 + (x2 div 8)+1;
			j := 0;
			while j < 4 do
			begin
				Read(fsave,ch1);
				if (ch1 and $C0) <> $C0 then
				begin
					display(i, j, ch1);
					inc(i);
					if i >= line_end then
					begin
						inc(j);
						i := k*80 + (x1 div 8);
					end;
				end
				else
				begin
					ch1 := ch1 and $3F;
					pass := ch1;
					Read(fsave,ch);
					for m:=0 to pass-1 do
					begin
						display(i, j, ch);
						inc(i);
						if i >= line_end then
						begin
							inc(j);
							i := k*80 + (x1 div 8);
						end;
					end;
				end;
			end;
		end;
		Port[$3CE] := 3;
		Port[$3CF] := 0;
		Port[$3CE] := 8;
		Port[$3CF] := $FF;
		Close(fsave);
		restore_screen := x2;
	end;


procedure move_cursor(C_type: integer; color: integer; min_col: integer;
	min_row: integer);
var
	screen_buffer: array[0..512] of byte;
	i,j,temp: integer;
	limit: array[0..6] of integer;
	regs: Registers;
	ch1: char;

begin
	DirectVideo := false;
	limit[0] := 10;
	limit[1] := 8;
	limit[2] := 9;
	limit[3] := 9;
	limit[4] := 11;
	limit[5] := 13;
	limit[6] := 13;
	with regs do
		repeat
			GetImage(CURSOR_X,CURSOR_Y,CURSOR_X+15,CURSOR_Y+15,
				screen_buffer);
			case C_type of
				0: begin
					for i:=0 to 15 do
					begin
						PutPixel(CURSOR_X+i,CURSOR_Y,15);
						PutPixel(CURSOR_X,CURSOR_Y+i,15);
					end;
				   end;
				1: begin
					for i:=0 to 15 do
					begin
						PutPixel(CURSOR_X+i,CURSOR_Y+15,15);
						PutPixel(CURSOR_X+15,CURSOR_Y+i,15);
					end;
				   end;
				2: begin
					for j:=0 to 6 do
					begin
						for i:=j to limit[j] do
						begin
							if (i=8) and (j=5) then
								i := 10;
							if (i=8) and (j=6) then
								i := 12;
							PutPixel(CURSOR_X+j,CURSOR_Y+i,15);
						end;
					end;
				   end;
				end;
			ch1 := ReadKey;
			if ch1 <> char($0D) then
			begin
				PutImage(CURSOR_X,CURSOR_Y,screen_buffer,0);
				AH := 2;
				intr($16,regs);
				if ch1 = char($00) then
				begin
					ch1 := ReadKey;
					case ch1 of
					 'M': begin
							if CURSOR_X < 639 then
								inc(CURSOR_X);
						 end;
					 'K': begin
							if CURSOR_X > min_col then
								dec(CURSOR_X);
						 end;
					 'H': begin;
							if CURSOR_Y > min_row then
								dec(CURSOR_Y);
						 end;
					 'P': begin
							if CURSOR_Y < 335 then
								inc(CURSOR_Y);
						 end;
					end;
				end
				else
				begin
					AH := 2;
					intr($16,regs);
					if (AL and $03) <> 0 then
					begin
						case ch1 of
							'8':  begin
									if CURSOR_Y > min_row then
										CURSOR_Y := CURSOR_Y - 10;
								end;
							'4':
								begin
									if CURSOR_X > min_col then
										CURSOR_X := CURSOR_X - 10;
								end;
							'6':
								begin
									if CURSOR_X < 613 then
										CURSOR_X := CURSOR_X + 10;
								end;
							'2':
								begin
									if CURSOR_Y < 323 then
										CURSOR_Y := CURSOR_Y + 10;
								end;
						end;
					end;
				end;
				case C_type of
					0: begin
						TXMin := XMin + (XMax - XMin)/
							639*(CURSOR_X);
						TYMax := YMax - (YMax - YMin)/
							349*CURSOR_Y;
						GotoXY(5,24);
						write('XMin: ',TXMin:7:6,'  YMax: ',TYMax:7:6,'    ');
					   end;
					1: begin
						TXMax := XMin + (XMax - XMin)/
							639*(CURSOR_X + 16);
						TYMin := YMax - (YMax - YMin)/
							349*(CURSOR_Y + 16);
						GotoXY(41,24);
						write('XMax: ',TXMax:7:6,'  YMin: ',TYMin:7:6,'    ');
					   end;
					2: begin
						Pval := XMin + (XMax - XMin)/639*
							CURSOR_X;
						Qval := YMax - (YMax - YMin)/
							349*CURSOR_Y;
						GotoXY(5,24);
						write('Pval: ',Pval:7:6,'   Qval: ',Qval:7:6);
					   end;
				end;
			end;
		until ch1 = char($0D);
	end;
end.
