program hil3d;

uses CRT,Graph,Fractal;

var
	GraphDriver,GraphMode,i,level: integer;
	points: array[0..2] of real;
	temp,x1,x2,y1,y2,r,x_angle,y_angle,z_angle,cx,cy,cz,sx,sy,sz: real;
	ch: char;


procedure generate (a: integer; b: integer; c: integer);

	var
		sign: array[0..2] of integer;

	begin
		sign[0] := 1;
		sign[1] := 1;
		sign[2] := 1;
		dec(level);
		if a < 0 then
			sign[0] := -1;
		a := Abs(a)-1;
		if b < 0 then
			sign[1] := -1;
		b := Abs(b)-1;
		if c < 0 then
			sign[2] := -1;
		c := Abs(c)-1;
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(-2,1,3);
		points[a] := points[a] + (r*sign[0]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(3,1,-2);
		points[b] := points[b] + (r*sign[1]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(3,1,-2);
		points[a] := points[a] - (r*sign[0]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(2,-3,1);
		points[c] := points[c] + (r*sign[2]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(-3,1,2);
		points[a] := points[a] + (r*sign[0]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(-2,3,1);
		points[b] := points[b] - (r*sign[1]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
			generate(3,-1,2);
		points[a] := points[a] - (r*sign[0]);
		x2 := points[0]*cx + points[1]*cy + points[2]*cz;
		y2 := points[0]*sx + points[1]*sy + points[2]*sz;
		Line(Round(x1+320),Round(175 - y1*0.729)
					,Round(x2+320),Round(175 - y2*0.729));
		x1 := points[0]*cx + points[1]*cy + points[2]*cz;
		y1 := points[0]*sx + points[1]*sy + points[2]*sz;
		if level > 0 then
		generate(-2,-1,-3);
		inc(level);
	end;


begin

	x_angle := -55;
	y_angle := 90;
	z_angle := 0;
	write('Enter level (1 - 8): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	sx := Sin(x_angle*0.017453292);
	sy := Sin(y_angle*0.017453292);
	sz := Sin(z_angle*0.017453292);
	cx := Cos(x_angle*0.017453292);
	cy := Cos(y_angle*0.017453292);
	cz := Cos(z_angle*0.017453292);
	temp := 2;
	i := level;
	while i>1 do
		begin
			temp := temp*2;
			dec(i);
		end;
	r := 300/temp;
	points[0] := -200;
	points[1] := 50;
	points[2] := 0;
	generate(3,-2,1);
	ch := ReadKey;
end.
