program hilbert;

uses CRT,Graph,Fractal;

var
	graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	x1,x2,y1,y2,r,r1,r2,temp: real;
	ch: char;


procedure generate (r1: real; r2: real);

	begin
		dec(level);
		if level > 0 then
			generate(r2,r1);
		x2 := x2 + r1;
		y2 := y2 + r2;
		Line(Round(x1+320),Round(175 - y1*0.729),Round(x2+320),Round(175
			- y2*0.729));
		x1 := x2;
		y1 := y2;
		if level > 0 then
			generate(r1,r2);
		x2 := x2 + r2;
		y2 := y2 + r1;
		Line(Round(x1+320),Round(175 - y1*0.729),Round(x2+320),Round(175
			- y2*0.729));
		x1 := x2;
		y1 := y2;
		if level > 0 then
			generate(r1,r2);
		x2 := x2 - r1;
		y2 := y2 - r2;
		Line(Round(x1+320),Round(175 - y1*0.729),Round(x2+320),Round(175
			- y2*0.729));
		x1 := x2;
		y1 := y2;
		if level > 0 then
			generate(-r2,-r1);
		inc(level);
	end;

begin

	write('Enter level (1 - 8): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	temp := 2;
	i := level;
	while i>1 do
		begin
			temp := temp*2;
			dec(i);
		end;
	r := 400/temp;
	x1 := -200;
	y1 := -200;
	x2 := -200;
	y2 := -200;
	generate(r,0);
	ch := ReadKey;
end.

