program hilbert2;

uses CRT,Graph,Fractal;

var
	graphDriver,GraphMode,i,j,level: integer;
	x,y,old_x,old_y,h: integer;
	ch: char;

procedure gen2(i: integer); forward;
procedure gen3(i: integer); forward;
procedure gen4(i: integer); forward;

procedure gen1(i: integer);
	begin
		if i > 0 then
		begin
			gen4(i-1);
			x := x - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen1(i-1);
			y := y - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen1(i-1);
			x := x + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen2(i-1);
		end;
	end;

procedure gen2(i: integer);
	begin
		if i > 0 then
		begin
			gen3(i-1);
			y := y + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen2(i-1);
			x := x + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen2(i-1);
			y := y - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen1(i-1);
		end;
	end;

procedure gen3(i: integer);
	begin
		if i > 0 then
		begin
			gen2(i-1);
			x := x + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen3(i-1);
			y := y + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen3(i-1);
			x := x - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen4(i-1);
		end;
	end;

procedure gen4(i: integer);
	begin
		if i > 0 then
		begin
			gen1(i-1);
			y := y - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen4(i-1);
			x := x - h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen4(i-1);
			y := y + h;
			Line(old_x+320,175-(old_y*35) div 48,x+320,175-(y*35) div 48);
			old_x := x;
			old_y := y;
			gen3(i-1);
		end;
	end;

begin
	write('Enter level (1 - 7): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	h := 448;
	x := 0;
	y := 0;
	for i:=1 to level do
	begin
		h := h div 2;
		x := x + h div 2;
		y := y + h div 2;
		old_x := x;
		old_y := y;
	end;
	gen1(level);
	ch := ReadKey;
end.
