program image3d;

uses CRT,Graph,Fractal;

const
	alpha: array[0..3] of real = (30,45,15,95);
	beta: array[0..3] of real = (115,105,70,40);
	gamma: array[0..3] of real = (25,70,20,-30);
	rad_per_degree: real = 0.0174533;
	hues: array[0..3] of integer = (2,10,11,14);

var
	GraphDriver,GraphMode,adapt,mode,k,xscale,yscale,xoffset,
		yoffset,pr,index: integer;
	i: longint;
	a,b,c,d,e,f,g,h,m,n,q,r: array[0..3] of real;
	x,y,z,newx,newy,j,ca,cb,cg,sa,sb,sg: real;
	p,pk: array[0..3] of real;
	ch1: char;

procedure image_draw;

	var
		px,py: integer;
		vx,vy: real;

	begin
		x := 0;
		y := 0;
		z := 0;
		for i:=1 to 25000 do
		begin
			j := Random;
			if j < p[0] then
				k := 0;
			if (j > p[0]) and (j < p[1]) then
				k := 1;
			if (j > p[1]) and (j < p[2]) then
				k := 2;
			if j > p[2] then
				k := 3;
			newx := (a[k]* x + b[k] * y + c[k] * z + n[k]);
			newy := (d[k]* x + e[k] * y + f[k] * z + q[k]);
			z := (g[k] * x + h[k] * y + m[k] * z + r[k]);
			x := newx;
			y := newy;
			vx := x*ca + y*cb + z*cg;
			vy := x*sa + y*sb + z*sg;
			px := Round(vx*xscale + xoffset);
			py := Round(vy*yscale + yoffset);
			if (px>=-320) and (px<320) and (py>=-240) and (py<240) then
			PutPixel(px+320,175 - ((93*py) div 128),hues[index]);
		end;
	end;

begin
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	setEGApalette(0,8);
	setEGApalette(2,2);
	setEGApalette(10,58);
	setEGApalette(11,62);
	setEGApalette(14,26);
	a[0] :=0; a[1] := 0.83; a[2] := 0.22; a[3] := -0.22;
	b[0] := 0; b[1] := 0; b[2] := -0.23; b[3] := 0.23;
	c[0] := 0; c[1] := 0; c[2] :=0; c[3] := 0;
	d[0] := 0; d[1] := 0; d[2] := 0.24; d[3] := 0.24;
	e[0] := 0.18; e[1] := 0.86; e[2] := 0.22; e[3] := 0.22;
	f[0] := 0; f[1] := 0.1; f[2] := 0; f[3] := 0;
	g[0] :=0; g[1] := 0; g[2] := 0; g[3] := 0;
	h[0] := 0; h[1] := -0.12; h[2] := 0; h[3] := 0;
	m[0] := 0; m[1] := 0.84; m[2] :=0.32; m[3] := 0.32;
	n[0] := 0; n[1] := 0; n[2] := 0; n[3] := 0;
	q[0] := 0; q[1] := 1.62; q[2] := 0.82; q[3] := 0.82;
	r[0] := 0; r[1] := 0; r[2] := 0; r[3] := 0;
	p[0] := 0.01; p[1] := 0.85; p[2] := 0.92; p[3] := 1.0;
	xscale := 40;
	yscale := 50;
	xoffset := 60;
	yoffset := -180;
	SetBkColor(0);
	ClearDevice;
	for index:=0 to 3 do
	begin
		ca := cos(alpha[index]*0.0174533);
		cb := cos(beta[index]*0.0174533);
		cg := cos(gamma[index]*0.0174533);
		sa := sin(alpha[index]*0.0174533);
		sb := sin(beta[index]*0.0174533);
		sg := sin(gamma[index]*0.0174533);
		image_draw;
	end;
	ch1 := ReadKey;
end.
